/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel;

import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.HashMap;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiTargetRegressor;
import moa.core.Measurement;
import moa.core.StringUtils;

public class MajorityLabelset
extends AbstractMultiLabelLearner
implements MultiTargetRegressor {
    private static final long serialVersionUID = 1L;
    private double maxValue = -1.0;
    private MultiLabelPrediction majorityLabelset = null;
    private HashMap<String, Double> vectorCounts = new HashMap();

    @Override
    public String getPurposeString() {
        return "Majority labelset classifier: always predicts the labelvector most frequently seen so far.";
    }

    @Override
    public void resetLearningImpl() {
        this.majorityLabelset = null;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance x) {
        int L = x.numberOutputTargets();
        MultiLabelPrediction y = new MultiLabelPrediction(L);
        for (int j = 0; j < L; ++j) {
            y.setVotes(j, new double[]{1.0 - x.classValue(j), x.classValue(j)});
        }
        double freq = x.weight();
        if (this.vectorCounts.containsKey(y.toString())) {
            freq += this.vectorCounts.get(y.toString()).doubleValue();
        }
        this.vectorCounts.put(y.toString(), freq);
        if (freq > this.maxValue) {
            this.maxValue = freq;
            this.majorityLabelset = y;
        }
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance x) {
        if (this.majorityLabelset == null) {
            int L = x.numberOutputTargets();
            return new MultiLabelPrediction(L);
        }
        return this.majorityLabelset;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent, "");
        out.append(this.majorityLabelset.toString());
        StringUtils.appendNewline(out);
    }
}

