/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.statisticaltests;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.ArffLoader;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import moa.classifiers.core.statisticaltests.StatisticalTest;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;
import org.apache.commons.math3.complex.Complex;

public class Cramer
extends AbstractOptionHandler
implements StatisticalTest {
    private List<Instance> sample1i;
    private List<Instance> sample2i;
    public FloatOption confidenceLevelOption = new FloatOption("confidenceLevel", 'q', "The confidence level to use in the Cramer test.", 0.95, 0.0, 1.0);
    public IntOption replicatesOption = new IntOption("replicates", 'r', "Number of replications.", 1000, 1, Integer.MAX_VALUE);
    public MultiChoiceOption kernelOption = new MultiChoiceOption("kernel", 'f', "Kernel function to use.", new String[]{"CRAMER", "BAHR", "LOG", "FRAC A", "FRAC B"}, new String[]{"CRAMER", "BAHR", "LOG", "FRAC A", "FRAC B"}, 0);
    public FloatOption maxMOption = new FloatOption("maxM", 'm', "Maximum M.", Math.pow(2.0, 14.0), 1.0, 3.4028234663852886E38);
    public IntOption kOption = new IntOption("k", 'k', "K value.", 160, 1, Integer.MAX_VALUE);
    public static final int CRAMER = 0;
    public static final int BAHR = 1;
    public static final int LOG = 2;
    public static final int FRACA = 3;
    public static final int FRACB = 4;

    private Complex[] fft(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = this.fft(even);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = this.fft(odd);
        Complex[] yy = new Complex[N];
        for (int k = 0; k < N / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            yy[k] = q[k].add(wk.multiply(r[k]));
            yy[k + N / 2] = q[k].subtract(wk.multiply(r[k]));
        }
        return yy;
    }

    private double phiCramer(double x) {
        return Math.sqrt(x) / 2.0;
    }

    private double phiBahr(double x) {
        return 1.0 - Math.exp(-x / 2.0);
    }

    private double phiLog(double x) {
        return Math.log(1.0 + x);
    }

    private double phiFracA(double x) {
        return 1.0 - 1.0 / (1.0 + x);
    }

    private double phiFracB(double x) {
        return 1.0 - 1.0 / ((1.0 + x) * (1.0 + x));
    }

    private double subtractRows(double[][] matrix, int i, int j) {
        double sum = 0.0;
        for (int k = 0; k < matrix[i].length; ++k) {
            sum += (matrix[i][k] - matrix[j][k]) * (matrix[i][k] - matrix[j][k]);
        }
        return sum;
    }

    private void kernel(int kernel, double[][] lookup) {
        for (double[] lookup1 : lookup) {
            block8: for (int j = 0; j < lookup1.length; ++j) {
                switch (kernel) {
                    case 0: {
                        lookup1[j] = this.phiCramer(lookup1[j]);
                        continue block8;
                    }
                    case 1: {
                        lookup1[j] = this.phiBahr(lookup1[j]);
                        continue block8;
                    }
                    case 3: {
                        lookup1[j] = this.phiFracA(lookup1[j]);
                        continue block8;
                    }
                    case 4: {
                        lookup1[j] = this.phiFracB(lookup1[j]);
                        continue block8;
                    }
                    case 2: {
                        lookup1[j] = this.phiLog(lookup1[j]);
                    }
                }
            }
        }
    }

    private double sumCells(double[][] lookup, int[] xind, int[] yind) {
        double sum = 0.0;
        for (int i = 0; i < xind.length; ++i) {
            for (int j = 0; j < yind.length; ++j) {
                sum += lookup[xind[i]][yind[j]];
            }
        }
        return sum;
    }

    private double cramerStatistic(int m, int n, double[][] lookup) {
        int[] xind = new int[m];
        for (int i = 0; i < m; ++i) {
            xind[i] = i;
        }
        int[] yind = new int[n];
        int i = m;
        int j = 0;
        while (i < m + n) {
            yind[j] = i++;
            ++j;
        }
        double mm = m;
        double nn = n;
        return mm * nn / (mm + nn) * (2.0 * this.sumCells(lookup, xind, yind) / (mm * nn) - this.sumCells(lookup, xind, xind) / (mm * mm) - this.sumCells(lookup, yind, yind) / (nn * nn));
    }

    private double rank(double t0, double[][] t) {
        double[] temp = new double[t.length * t[0].length + 1];
        temp[0] = t0;
        int p = 1;
        for (double[] t1 : t) {
            for (int j = 0; j < t1.length; ++j) {
                temp[p++] = t1[j];
            }
        }
        double[] ordTemp = (double[])temp.clone();
        Arrays.sort(ordTemp);
        TreeMap<Double, Double> map = new TreeMap<Double, Double>();
        for (int i = 0; i < ordTemp.length; ++i) {
            double xTemp = ordTemp[i];
            double sum = i;
            int count = 1;
            while (i + 1 < ordTemp.length && xTemp == ordTemp[++i]) {
                sum += (double)i;
                ++count;
            }
            map.put(xTemp, 1.0 + sum / (double)count);
            if (i + 1 == ordTemp.length) {
                map.put(ordTemp[i], 1.0 + (double)i);
                break;
            }
            --i;
        }
        return (Double)map.get(t0);
    }

    private double[] linearize(double[][] matrix) {
        double[] vector = new double[matrix.length * matrix[0].length];
        int p = 0;
        for (double[] matrix1 : matrix) {
            for (int j = 0; j < matrix1.length; ++j) {
                vector[p++] = matrix1[j];
            }
        }
        return vector;
    }

    private double[] createVector(int replicates) {
        double[] result = new double[replicates];
        for (int i = 0; i < replicates; ++i) {
            result[i] = (i + 1) / replicates;
        }
        return result;
    }

    private void divide(double[] vector, double divisor) {
        int i = 0;
        while (i < vector.length) {
            int n = i++;
            vector[n] = vector[n] / divisor;
        }
    }

    private void divide(double[][] matrix, double divisor) {
        for (double[] matrix1 : matrix) {
            int j = 0;
            while (j < matrix1.length) {
                int n = j++;
                matrix1[n] = matrix1[n] / divisor;
            }
        }
    }

    private double[] createArray(int M, double k) {
        double[] result = new double[M];
        for (int i = 0; i < M; ++i) {
            result[i] = (double)i * k / (double)M;
        }
        return result;
    }

    private double[] createArray2(int M, double k) {
        double[] result = new double[M];
        for (int i = 0; i < M; ++i) {
            result[i] = (double)(i * 2) * Math.PI / k;
        }
        return result;
    }

    private Complex[][] complex(Complex[] v, double[] t) {
        Complex[][] complex = new Complex[v.length][t.length];
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < t.length; ++j) {
                complex[i][j] = v[i].multiply(t[j]).add(new Complex(1.0, 0.0)).log().multiply(-0.5);
            }
        }
        return complex;
    }

    private Complex[] characteristic(double[] lambdasquare, double[] t) {
        Complex c = new Complex(0.0, -2.0);
        Complex[] temp = new Complex[lambdasquare.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = c.multiply(lambdasquare[i]);
        }
        Complex[][] z = this.complex(temp, t);
        double[] real = new double[t.length];
        double[] imag = new double[t.length];
        for (int j = 0; j < t.length; ++j) {
            for (Complex[] z1 : z) {
                int n = j;
                real[n] = real[n] + z1[j].getReal();
                int n2 = j;
                imag[n2] = imag[n2] + z1[j].getImaginary();
            }
        }
        Complex[] result = new Complex[t.length];
        for (int i = 0; i < t.length; ++i) {
            result[i] = new Complex(real[i], imag[i]);
            result[i] = result[i].exp();
        }
        return result;
    }

    private double[] imaginary(Complex[] c) {
        double[] ret = new double[c.length];
        for (int i = 0; i < c.length; ++i) {
            ret[i] = c[i].getImaginary();
        }
        return ret;
    }

    private double[] plus(double[] array, double m) {
        double[] ret = new double[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i] + m;
        }
        return ret;
    }

    private double sum(double[] lambdasquare) {
        double sum = 0.0;
        for (int i = 0; i < lambdasquare.length; ++i) {
            sum += lambdasquare[i];
        }
        return sum;
    }

    private double[] sum(double[] a, double[] b) {
        double[] c = new double[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    private int whichMin(double[] a, int M, double confLevel) {
        double[] ret = new double[M / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Math.abs(a[i] - confLevel);
        }
        int minIndex = 0;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < ret.length; ++i) {
            if (!(ret[i] < minValue)) continue;
            minValue = ret[i];
            minIndex = i;
        }
        return minIndex;
    }

    private int whichMin(double[] ret) {
        int minIndex = 0;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < ret.length; ++i) {
            if (!(ret[i] < minValue)) continue;
            minValue = ret[i];
            minIndex = i;
        }
        return minIndex;
    }

    private Complex[] multiply(double[] t, Complex c) {
        Complex[] ret = new Complex[t.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = c.multiply(t[i]);
        }
        return ret;
    }

    private void multiply(double[] t, Complex[] c) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = c[i].multiply(t[i]);
        }
    }

    private void multiply(Complex[] c, double multiply) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = c[i].multiply(multiply);
        }
    }

    private void multiply(double[] c, double multiply) {
        int i = 0;
        while (i < c.length) {
            int n = i++;
            c[n] = c[n] * multiply;
        }
    }

    private Kritwert kritwertfft(double[] lambdasquare, double confLevel, double maxM, int k) {
        int i;
        double sumLambasquare = this.sum(lambdasquare);
        int M = (int)Math.pow(2.0, 11.0);
        while (471.23889803846896 * (double)M / (double)(k * k) < 2.0 * sumLambasquare + lambdasquare[0]) {
            M *= 2;
        }
        M = (int)Math.min((double)M, maxM);
        double goodlimit = 471.23889803846896 * (double)M / (double)(k * k);
        double[] t = this.createArray(M, k);
        double[] xx = this.createArray2(M, k);
        t[0] = 1.0;
        Complex[] h = this.characteristic(lambdasquare, t);
        Complex z = new Complex(0.0, 1.0).multiply(0);
        Complex[] hTemp = this.multiply(t, z);
        for (i = 0; i < hTemp.length; ++i) {
            hTemp[i] = hTemp[i].exp();
        }
        this.multiply(t, hTemp);
        for (i = 0; i < h.length; ++i) {
            h[i] = h[i].divide(hTemp[i]);
        }
        h[0] = new Complex(0.0, 1.0).multiply(sumLambasquare);
        Complex[] temp = this.fft(h);
        this.multiply(temp, (double)k / ((double)M * Math.PI));
        double[] tempFx = this.imaginary(temp);
        this.multiply(tempFx, -1.0);
        tempFx = this.plus(tempFx, 0.5);
        double[] tempX = this.plus(xx, sumLambasquare);
        this.multiply(tempX, (double)k / ((double)(2 * M) * Math.PI));
        double[] Fx = this.sum(tempFx, tempX);
        int xindex = this.whichMin(Fx, M, confLevel);
        if (Fx[xindex] > confLevel) {
            --xindex;
        }
        if (xindex < 1) {
            xindex = 0;
        }
        double quantile = xx[xindex] + (confLevel - Fx[xindex]) * (xx[xindex + 1] - xx[xindex]) / (Fx[xindex + 1] - Fx[xindex]);
        if (Fx[M / 2] < confLevel) {
            System.out.println("Quantile calculation discrepance. Try to increase K!");
        }
        if (quantile > goodlimit) {
            System.out.println("Quantile beyond good approximation limit. Try to increase maxM or decrease K!");
        }
        return new Kritwert(quantile, xx, Fx);
    }

    public CramerTest cramerTest(List<Instance> x, List<Instance> y) {
        return this.cramerTest(x, y, this.confidenceLevelOption.getValue(), this.replicatesOption.getValue(), "ordinary", false, this.kernelOption.getChosenIndex(), this.maxMOption.getValue(), this.kOption.getValue());
    }

    public CramerTest cramerTest1(List<List<Double>> x, List<List<Double>> y) {
        return this.cramerTest1(x, y, this.confidenceLevelOption.getValue(), this.replicatesOption.getValue(), "ordinary", false, this.kernelOption.getChosenIndex(), this.maxMOption.getValue(), this.kOption.getValue());
    }

    public CramerTest cramerTest1(List<List<Double>> x, List<List<Double>> y, double confLevel, int replicates, String sim, boolean justStatistic, int kernel, double maxM, int k) {
        double[] values;
        int i;
        CramerTest RVAL = new CramerTest(0, 0, 0, 0.0, 0.0, 0.0, 0.0, confLevel, replicates, null, null, null);
        RVAL.d = x.get(0).size();
        RVAL.m = x.size();
        RVAL.n = y.size();
        double[][] daten = new double[RVAL.m + RVAL.n][];
        for (i = 0; i < RVAL.m; ++i) {
            values = new double[x.get(i).size() - 1];
            System.arraycopy(x.get(i).toArray(), 0, values, 0, values.length);
            daten[i] = values;
        }
        for (i = 0; i < RVAL.n; ++i) {
            values = new double[y.get(i).size() - 1];
            System.arraycopy(y.get(i).toArray(), 0, values, 0, values.length);
            daten[i + RVAL.m] = values;
        }
        return this.compute(RVAL, daten, replicates, sim, justStatistic, kernel, maxM, k);
    }

    private CramerTest compute(CramerTest RVAL, double[][] daten, int replicates, String sim, boolean justStatistic, int kernel, double maxM, int k) {
        double[][] lookup = new double[RVAL.m + RVAL.n][RVAL.m + RVAL.n];
        for (int i = 1; i < RVAL.m + RVAL.n; ++i) {
            for (int j = 0; j <= i - 1; ++j) {
                lookup[i][j] = this.subtractRows(daten, i, j);
                lookup[j][i] = lookup[i][j];
            }
        }
        this.kernel(kernel, lookup);
        if (justStatistic) {
            RVAL.statistic = this.cramerStatistic(RVAL.m, RVAL.n, lookup);
        } else if (sim.equals("eigenvalue")) {
            Boot boot = new Boot();
            RVAL.statistic = boot.t0;
            RVAL.pValue = 1.0 - this.rank(boot.t0, boot.t) / (double)(replicates + 1);
            double[] toSort = this.linearize(boot.t);
            Arrays.sort(toSort);
            RVAL.critValue = toSort[(int)Math.round(RVAL.confLevel * RVAL.replicates)];
            if (RVAL.statistic > RVAL.critValue) {
                RVAL.result = 1.0;
            }
            RVAL.hypdistX = toSort;
            RVAL.hypdistFx = this.createVector(replicates);
        } else {
            RVAL.statistic = this.cramerStatistic(RVAL.m, RVAL.n, lookup);
            int N = RVAL.m + RVAL.n;
            double[] C1 = new double[N];
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    int n = i;
                    C1[n] = C1[n] + lookup[i][j];
                }
            }
            this.divide(C1, (double)N);
            double C2 = 0.0;
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    C2 += lookup[i][j];
                }
            }
            C2 /= (double)(N * N);
            double[][] B = new double[N][N];
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    B[i][j] = C1[i] + C1[j] - C2 - lookup[i][j];
                }
            }
            this.divide(B, (double)N);
            Matrix matrix = new Matrix(B);
            EigenvalueDecomposition evd = matrix.eig();
            double[] lambdasquare = evd.getRealEigenvalues();
            Arrays.sort(lambdasquare);
            this.reverse(lambdasquare);
            RVAL.ev = lambdasquare;
            Kritwert kw = this.kritwertfft(lambdasquare, RVAL.confLevel, maxM, k);
            double[] temp = Arrays.copyOf(kw.x, 3 * kw.x.length / 4);
            temp = this.plus(temp, -RVAL.statistic);
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = Math.abs(temp[i]);
            }
            RVAL.pValue = 1.0 - kw.Fx[this.whichMin(temp)];
            RVAL.critValue = kw.quantile;
            RVAL.hypdistX = kw.x;
            RVAL.hypdistFx = kw.Fx;
            if (RVAL.statistic > RVAL.critValue) {
                RVAL.result = 1.0;
            }
        }
        return RVAL;
    }

    public CramerTest cramerTest(List<Instance> x, List<Instance> y, double confLevel, int replicates, String sim, boolean justStatistic, int kernel, double maxM, int k) {
        int j;
        double[] values;
        Instance inst;
        int i;
        CramerTest RVAL = new CramerTest(0, 0, 0, 0.0, 0.0, 0.0, 0.0, confLevel, replicates, null, null, null);
        RVAL.d = x.get(0).numAttributes();
        RVAL.m = x.size();
        RVAL.n = y.size();
        double[][] daten = new double[RVAL.m + RVAL.n][];
        for (i = 0; i < RVAL.m; ++i) {
            inst = x.get(i);
            values = new double[inst.numAttributes() - 1];
            for (j = 0; j < values.length; ++j) {
                values[j] = inst.value(j);
            }
            daten[i] = values;
        }
        for (i = 0; i < RVAL.n; ++i) {
            inst = y.get(i);
            values = new double[inst.numAttributes() - 1];
            for (j = 0; j < values.length; ++j) {
                values[j] = inst.value(j);
            }
            daten[i + RVAL.m] = values;
        }
        return this.compute(RVAL, daten, replicates, sim, justStatistic, kernel, maxM, k);
    }

    private void reverse(double[] array) {
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            double temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static List<Instance> fileToInstances(String path) {
        ArrayList<Instance> x = new ArrayList<Instance>();
        try {
            FileReader reader = new FileReader(path);
            ArffLoader arff = new ArffLoader(reader, 1, -1);
            Instance inst = arff.readInstance();
            while (inst != null) {
                x.add(inst);
                inst = arff.readInstance();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        return x;
    }

    public static List<List<Double>> fileToMatrix(String path) {
        ArrayList<List<Double>> x = new ArrayList<List<Double>>();
        try {
            FileReader reader = new FileReader(path);
            ArffLoader arff = new ArffLoader(reader, 1, -1);
            Instance inst = arff.readInstance();
            while (inst != null) {
                double[] dArray = inst.toDoubleArray();
                ArrayList<Double> list = new ArrayList<Double>();
                for (double d : dArray) {
                    list.add(d);
                }
                x.add(list);
                inst = arff.readInstance();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        return x;
    }

    public static void main(String[] args) throws Exception {
        List<Instance> x = Cramer.fileToInstances("c:\\Users\\Paulo\\Documents\\test1-x.arff");
        List<Instance> y = Cramer.fileToInstances("c:\\Users\\Paulo\\Documents\\test1-y.arff");
        Cramer c = new Cramer();
        CramerTest ct = c.cramerTest(x, y);
        System.out.println("p Value [Resultado esperado: 0.7092907] [Resultado obtido..: " + ct.pValue + "]");
        System.out.println("Critical value [Resultado esperado: 2.379552] [Resultado obtido: " + ct.critValue + "]");
        System.out.println("Statistic [Resultado esperado: 0.8160198] [Resultado obtido: " + ct.statistic + "]");
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public double test(List<Instance> x, List<Instance> y) {
        return this.cramerTest(x, y).confLevel;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public Double call() throws Exception {
        return this.test(this.sample1i, this.sample2i);
    }

    @Override
    public void set(List<Instance> x, List<Instance> y) {
        this.sample1i = x;
        this.sample2i = y;
    }

    public class CramerTest {
        int d;
        int m;
        int n;
        double pValue;
        double critValue;
        double statistic;
        double result;
        double confLevel;
        double replicates;
        double[] hypdistX;
        double[] hypdistFx;
        double[] ev;

        public CramerTest(int d, int m, int n, double pValue, double critValue, double statistic, double result, double confLevel, double replicates, double[] hypdistX, double[] hypdistFx, double[] ev) {
            this.d = d;
            this.m = m;
            this.n = n;
            this.pValue = pValue;
            this.critValue = critValue;
            this.statistic = statistic;
            this.result = result;
            this.confLevel = confLevel;
            this.replicates = replicates;
            this.hypdistX = hypdistX;
            this.hypdistFx = hypdistFx;
            this.ev = ev;
        }
    }

    class Kritwert {
        double quantile;
        double[] x;
        double[] Fx;

        public Kritwert(double quantile, double[] x, double[] fx) {
            this.quantile = quantile;
            this.x = x;
            this.Fx = fx;
        }
    }

    class Boot {
        double t0;
        double[][] t;

        Boot() {
        }
    }
}

