/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser;

import com.github.javacliparser.Option;
import com.github.javacliparser.SerializeUtils;

public abstract class AbstractOption
implements Option {
    public static final char[] illegalNameCharacters = new char[]{' ', '-', '(', ')'};
    protected String name;
    protected char cliChar;
    protected String purpose;

    public static boolean nameIsLegal(String optionName) {
        for (char illegalChar : illegalNameCharacters) {
            if (optionName.indexOf(illegalChar) < 0) continue;
            return false;
        }
        return true;
    }

    public AbstractOption(String name, char cliChar, String purpose) {
        if (!AbstractOption.nameIsLegal(name)) {
            throw new IllegalArgumentException("Illegal option name: " + name);
        }
        this.name = name;
        this.cliChar = cliChar;
        this.purpose = purpose;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public char getCLIChar() {
        return this.cliChar;
    }

    @Override
    public String getPurpose() {
        return this.purpose;
    }

    @Override
    public void resetToDefault() {
        this.setValueViaCLIString(this.getDefaultCLIString());
    }

    @Override
    public String getStateString() {
        return this.getValueAsCLIString();
    }

    @Override
    public Option copy() {
        try {
            return (Option)SerializeUtils.copyObject(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Object copy failed.", e);
        }
    }
}

