/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import moa.cluster.SphereCluster;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.gui.visualization.StreamOutlierPanel;

public class OutlierPanel
extends JPanel {
    private boolean bAntiAlias = false;
    private MyBaseOutlierDetector myOutlierDetector;
    private MyBaseOutlierDetector.Outlier myOutlier;
    private SphereCluster cluster;
    JDialog frameInfo = null;
    private double[] center;
    private static final int DRAW_SIZE = 4;
    protected double decay_rate;
    protected int x_dim = 0;
    protected int y_dim = 1;
    protected Color col;
    protected Color default_color = Color.BLACK;
    protected StreamOutlierPanel streamPanel;
    protected int panel_size;
    protected int window_size;
    protected boolean highligted = false;
    private double r;

    public OutlierPanel(MyBaseOutlierDetector myOutlierDetector, MyBaseOutlierDetector.Outlier outlier, SphereCluster cluster, Color color, StreamOutlierPanel sp) {
        this.myOutlierDetector = myOutlierDetector;
        this.myOutlier = outlier;
        this.cluster = cluster;
        this.center = cluster.getCenter();
        this.r = cluster.getRadius();
        this.streamPanel = sp;
        this.default_color = this.col = color;
        this.setVisible(true);
        this.setOpaque(false);
        this.setSize(new Dimension(1, 1));
        this.setLocation(0, 0);
        this.initComponents();
    }

    public void setDirection(double[] direction) {
    }

    public void updateLocation() {
        this.x_dim = this.streamPanel.getActiveXDim();
        this.y_dim = this.streamPanel.getActiveYDim();
        if (this.cluster != null && this.center == null) {
            this.getParent().remove(this);
        } else {
            this.window_size = Math.min(this.streamPanel.getWidth(), this.streamPanel.getHeight());
            this.panel_size = 5;
            this.setSize(new Dimension(this.panel_size, this.panel_size));
            int x = (int)Math.round(this.center[this.x_dim] * (double)this.window_size);
            int y = (int)Math.round(this.center[this.y_dim] * (double)this.window_size);
            this.setLocation(x - this.panel_size / 2, y - this.panel_size / 2);
        }
    }

    public void updateTooltip() {
    }

    @Override
    public boolean contains(int x, int y) {
        double dist = Math.sqrt(Math.pow(x - this.panel_size / 2, 2.0) + Math.pow(y - this.panel_size / 2, 2.0));
        return (double)(this.panel_size / 2 - 5) < dist && dist < (double)(this.panel_size / 2 + 5);
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OutlierPanel.this.formMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 266, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        this.streamPanel.setHighlightedOutlierPanel(this);
        this.showInfo();
        this.streamPanel.setHighlightedOutlierPanel(null);
    }

    public String getInfo() {
        return this.myOutlierDetector.getObjectInfo(this.myOutlier.obj);
    }

    private void showInfo() {
        String title = "Outlier information";
        JLabel comp = new JLabel();
        comp.setText(this.getInfo());
        JOptionPane pane = new JOptionPane(comp);
        pane.setOptionType(-1);
        pane.setMessageType(-1);
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point mousePoint = pointerInfo.getLocation();
        JDialog dialog = pane.createDialog(this, title);
        dialog.setLocation(mousePoint);
        dialog.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.bAntiAlias) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.updateLocation();
        if (this.highligted) {
            g.setColor(Color.ORANGE);
        } else {
            g.setColor(this.default_color);
        }
        int drawSize = 4;
        int drawStart = 0;
        g.fillOval(drawStart, drawStart, drawSize, drawSize);
        g.drawOval(drawStart, drawStart, drawSize, drawSize);
    }

    public void highlight(boolean enabled) {
        this.highligted = enabled;
        this.repaint();
    }

    public boolean isValidCluster() {
        return this.center != null;
    }

    public int getClusterID() {
        return (int)this.cluster.getId();
    }

    public int getClusterLabel() {
        return (int)this.cluster.getGroundTruth();
    }

    public String getSVGString(int width) {
        StringBuffer out = new StringBuffer();
        int x = (int)(this.center[this.x_dim] * (double)this.window_size);
        int y = (int)(this.center[this.y_dim] * (double)this.window_size);
        int radius = this.panel_size / 2;
        out.append("<circle ");
        out.append("cx='" + x + "' cy='" + y + "' r='" + radius + "'");
        out.append(" stroke='green' stroke-width='1' fill='white' fill-opacity='0' />");
        out.append("\n");
        return out.toString();
    }

    public void drawOnCanvas(Graphics2D imageGraphics) {
        int x = (int)(this.center[this.x_dim] * (double)this.window_size - (double)(this.panel_size / 2));
        int y = (int)(this.center[this.y_dim] * (double)this.window_size - (double)(this.panel_size / 2));
        int radius = this.panel_size;
        imageGraphics.drawOval(x, y, radius, radius);
    }
}

