/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.colorGenerator;

import java.awt.Color;
import java.util.Random;
import moa.gui.colorGenerator.ColorGenerator;

public class HSVColorGenerator
implements ColorGenerator {
    private float hueMin;
    private float hueMax;
    private float saturationMin;
    private float saturationMax;
    private float brightnessMin;
    private float brightnessMax;

    public HSVColorGenerator() {
        this(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public HSVColorGenerator(float saturationMin, float saturationMax, float brightnessMin, float brightnessMax) {
        this(0.0f, 1.0f, saturationMin, saturationMax, brightnessMin, brightnessMax);
    }

    public HSVColorGenerator(float hueMin, float hueMax, float saturationMin, float saturationMax, float brightnessMin, float brightnessMax) {
        this.hueMin = hueMin;
        this.hueMax = hueMax;
        this.saturationMin = saturationMin;
        this.saturationMax = saturationMax;
        this.brightnessMin = brightnessMin;
        this.brightnessMax = brightnessMax;
    }

    @Override
    public Color[] generateColors(int numColors) {
        Color[] colors = new Color[numColors];
        Random rand = new Random(0L);
        for (int i = 0; i < numColors; ++i) {
            float hueRatio = (float)i / (float)numColors;
            float saturationRatio = rand.nextFloat();
            float brightnessRatio = rand.nextFloat();
            float hue = this.lerp(this.hueMin, this.hueMax, hueRatio);
            float saturation = this.lerp(this.saturationMin, this.saturationMax, saturationRatio);
            float brightness = this.lerp(this.brightnessMin, this.brightnessMax, brightnessRatio);
            colors[i] = Color.getHSBColor(hue, saturation, brightness);
        }
        return colors;
    }

    private float lerp(float min, float max, float ratio) {
        return min + (max - min) * ratio;
    }
}

