/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.core.Example;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.evaluation.MultiTargetPerformanceEvaluator;
import moa.evaluation.RegressionPerformanceEvaluator;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class MultiTargetWindowRegressionPerformanceRelativeMeasuresEvaluator
extends AbstractOptionHandler
implements MultiTargetPerformanceEvaluator,
RegressionPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window", 1000);
    protected double TotalweightObserved = 0.0;
    protected Estimator weightObserved;
    protected Estimator[] squareError;
    protected Estimator[] averageError;
    protected Estimator[] averageErrorToTargetMean;
    protected Estimator[] squareErrorToTargetMean;
    protected Estimator[] sumY;
    protected int numClasses;
    protected int numberOutputs;

    @Override
    public void reset() {
        this.reset(this.numClasses);
    }

    public void reset(int numClasses) {
        this.numClasses = numClasses;
        this.weightObserved = new Estimator(this.widthOption.getValue());
        this.TotalweightObserved = 0.0;
    }

    @Override
    public void addResult(Example<Instance> example, double[] prediction) {
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("relative mean absolute error", this.getMeanError()), new Measurement("relative root mean squared error", this.getSquareError())};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved.total();
    }

    public double getMeanError() {
        double error = 0.0;
        if (this.weightObserved.total() > 0.0) {
            for (int i = 0; i < this.averageError.length; ++i) {
                error += this.averageError[i].total() / this.averageErrorToTargetMean[i].total();
            }
            error /= (double)this.averageError.length;
        }
        return error;
    }

    public double getSquareError() {
        double error = 0.0;
        if (this.weightObserved.total() > 0.0) {
            for (int i = 0; i < this.squareError.length; ++i) {
                error += Math.sqrt(this.squareError[i].total() / this.squareErrorToTargetMean[i].total());
            }
            error /= (double)this.squareError.length;
        }
        return error;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public void addResult(Example<Instance> testInst, Prediction prediction) {
        MultiLabelInstance inst = (MultiLabelInstance)testInst.getData();
        if (this.squareError == null) {
            this.squareError = new Estimator[inst.numOutputAttributes()];
            this.averageError = new Estimator[inst.numOutputAttributes()];
            this.averageErrorToTargetMean = new Estimator[inst.numOutputAttributes()];
            this.squareErrorToTargetMean = new Estimator[inst.numOutputAttributes()];
            this.sumY = new Estimator[inst.numOutputAttributes()];
            for (int i = 0; i < inst.numOutputAttributes(); ++i) {
                this.averageError[i] = new Estimator(this.widthOption.getValue());
                this.averageErrorToTargetMean[i] = new Estimator(this.widthOption.getValue());
                this.squareError[i] = new Estimator(this.widthOption.getValue());
                this.squareErrorToTargetMean[i] = new Estimator(this.widthOption.getValue());
                this.sumY[i] = new Estimator(this.widthOption.getValue());
            }
        }
        double weight = inst.weight();
        if (this.numberOutputs == 0) {
            this.numberOutputs = inst.numberOutputTargets();
        }
        if (weight > 0.0) {
            if (this.TotalweightObserved == 0.0) {
                this.reset(inst.dataset().numClasses());
            }
            this.TotalweightObserved += weight;
            this.weightObserved.add(weight);
            if (prediction != null) {
                for (int i = 0; i < this.numberOutputs; ++i) {
                    double error = inst.valueOutputAttribute(i) - prediction.getVote(i, 0);
                    this.sumY[i].add(inst.valueOutputAttribute(i));
                    double errorTM = inst.valueOutputAttribute(i) - this.sumY[i].total() / this.weightObserved.total();
                    this.averageErrorToTargetMean[i].add(Math.abs(errorTM));
                    this.squareErrorToTargetMean[i].add(errorTM * errorTM);
                    this.averageError[i].add(Math.abs(error));
                    this.squareError[i].add(error * error);
                }
            }
        }
    }

    public class Estimator {
        protected double[] window;
        protected int posWindow;
        protected int lenWindow;
        protected int SizeWindow;
        protected double sum;

        public Estimator(int sizeWindow) {
            this.window = new double[sizeWindow];
            this.SizeWindow = sizeWindow;
            this.posWindow = 0;
        }

        public void add(double value) {
            this.sum -= this.window[this.posWindow];
            this.sum += value;
            this.window[this.posWindow] = value;
            ++this.posWindow;
            if (this.posWindow == this.SizeWindow) {
                this.posWindow = 0;
            }
        }

        public double total() {
            return this.sum;
        }
    }
}

