/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AnyOut.util;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;

public class EMProjectedClustering {
    private long randomSeed = 1L;
    double[][] pointArray;
    int n;
    int dim;
    int k;
    private final double minVariance = 0.01;
    private final double minDeviation = 0.01;
    private final int MAXITER = 20;
    double[][] clusterMeans;
    double[][] clusterVariances;
    double[][] pXgivenC;
    double[][] pCgivenX;
    double[] clusterWeights;
    double[] pX;

    public int[][] getEMClusteringVariances(double[][] pointArray, int k) {
        double currentExpectation;
        double expectationDeviation;
        this.initFields(pointArray, k);
        this.setInitialPartitions(pointArray, k);
        double newExpectation = 0.0;
        int count = 0;
        do {
            currentExpectation = newExpectation;
            this.getNewClusterRepresentation();
            this.calculateAllProbabilities();
        } while ((expectationDeviation = 1.0 - currentExpectation / (newExpectation = this.expectation())) > 0.01 && ++count < 20);
        return this.createProjectedClustering();
    }

    public int[][] getEMClusteringVariancesBestChoice(double[][] pointArray, int k, int nrOfChoices) {
        nrOfChoices = Math.max(1, nrOfChoices);
        int[][] bestChoice = null;
        int[][] tmpChoice = null;
        double bestMeasure = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < nrOfChoices; ++i) {
            this.randomSeed = i;
            tmpChoice = this.getEMClusteringVariances(pointArray, k);
            double tmpMeasure = this.expectation();
            if (!(tmpMeasure > bestMeasure)) continue;
            bestMeasure = tmpMeasure;
            bestChoice = tmpChoice;
        }
        return bestChoice;
    }

    private void initFields(double[][] pointArray, int k) {
        this.pointArray = pointArray;
        this.n = pointArray.length;
        this.dim = pointArray[0].length;
        this.k = k;
        this.clusterMeans = new double[k][this.dim];
        this.clusterVariances = new double[k][this.dim];
        this.pXgivenC = new double[this.n][k];
        this.pCgivenX = new double[k][this.n];
        this.clusterWeights = new double[k];
        this.pX = new double[this.n];
    }

    private void setInitialPartitions(double[][] pointArray, int k) {
        if (pointArray.length < k) {
            System.err.println("cannot cluster less than k points into k clusters...");
            System.exit(0);
        }
        Random random = new Random(this.randomSeed);
        TreeSet usedPoints = new TreeSet();
        for (int i = 0; i < k; ++i) {
            int nextIndex = Double.valueOf(Math.floor(random.nextDouble() * (double)this.n)).intValue();
            if (usedPoints.contains(nextIndex)) {
                --i;
                continue;
            }
            for (int d = 0; d < this.dim; ++d) {
                this.clusterMeans[i][d] = pointArray[nextIndex][d];
            }
        }
        int minDistIndex = 0;
        for (int x = 0; x < pointArray.length; ++x) {
            double minDist = Double.MAX_VALUE;
            for (int i = 0; i < k; ++i) {
                double currentDist = this.euclideanDistance(this.clusterMeans[i], pointArray[x]);
                if (!(currentDist < minDist)) continue;
                minDist = currentDist;
                minDistIndex = i;
            }
            this.pCgivenX[minDistIndex][x] = 1.0;
        }
    }

    private double euclideanDistance(double[] x, double[] y) {
        double result = 0.0;
        for (int i = 0; i < x.length; ++i) {
            result += (x[i] - y[i]) * (x[i] - y[i]);
        }
        return Math.sqrt(result);
    }

    private void getNewClusterRepresentation() {
        this.calculateWeights();
        this.calculateMeans();
        this.calculateVariances();
    }

    private void calculateWeights() {
        int i = 0;
        while (i < this.k) {
            this.clusterWeights[i] = 0.0;
            for (int x = 0; x < this.n; ++x) {
                int n = i;
                this.clusterWeights[n] = this.clusterWeights[n] + this.pCgivenX[i][x];
            }
            int n = i++;
            this.clusterWeights[n] = this.clusterWeights[n] / (double)this.n;
        }
    }

    private void calculateMeans() {
        for (int i = 0; i < this.k; ++i) {
            for (int d = 0; d < this.dim; ++d) {
                this.clusterMeans[i][d] = 0.0;
                if (this.clusterWeights[i] <= 0.0) continue;
                for (int x = 0; x < this.n; ++x) {
                    double[] dArray = this.clusterMeans[i];
                    int n = d;
                    dArray[n] = dArray[n] + this.pointArray[x][d] * this.pCgivenX[i][x];
                }
                double[] dArray = this.clusterMeans[i];
                int n = d;
                dArray[n] = dArray[n] / (this.clusterWeights[i] * (double)this.n);
            }
        }
    }

    private void calculateVariances() {
        for (int i = 0; i < this.k; ++i) {
            for (int d = 0; d < this.dim; ++d) {
                this.clusterVariances[i][d] = 0.0;
                if (this.clusterWeights[i] <= 0.0) continue;
                for (int x = 0; x < this.n; ++x) {
                    double xMinusMu = this.pointArray[x][d] - this.clusterMeans[i][d];
                    double[] dArray = this.clusterVariances[i];
                    int n = d;
                    dArray[n] = dArray[n] + this.pCgivenX[i][x] * (xMinusMu * xMinusMu);
                }
                double d2 = this.clusterVariances[i][d];
                Objects.requireNonNull(this);
                if (d2 < 0.01) {
                    double[] dArray = this.clusterVariances[i];
                    Objects.requireNonNull(this);
                    dArray[d] = 0.01;
                    continue;
                }
                double[] dArray = this.clusterVariances[i];
                int n = d;
                dArray[n] = dArray[n] / (this.clusterWeights[i] * (double)this.n);
            }
        }
    }

    private void calculateClassConditionalDensities() {
        for (int i = 0; i < this.pXgivenC[0].length; ++i) {
            int x;
            if (this.clusterWeights[i] <= 0.0) {
                for (x = 0; x < this.pXgivenC.length; ++x) {
                    this.pXgivenC[x][i] = 0.0;
                }
                continue;
            }
            double factor = Math.pow(Math.PI * 2, (double)this.dim / 2.0);
            for (int d = 0; d < this.dim; ++d) {
                factor *= Math.sqrt(this.clusterVariances[i][d]);
            }
            factor = 1.0 / factor;
            for (x = 0; x < this.pXgivenC.length; ++x) {
                double exponent = 0.0;
                for (int d = 0; d < this.dim; ++d) {
                    double xMinusMu = this.pointArray[x][d] - this.clusterMeans[i][d];
                    exponent += xMinusMu * xMinusMu / this.clusterVariances[i][d];
                }
                this.pXgivenC[x][i] = factor * Math.exp(exponent *= -0.5);
            }
        }
    }

    private void calculatePX() {
        for (int x = 0; x < this.n; ++x) {
            this.pX[x] = 0.0;
            for (int i = 0; i < this.k; ++i) {
                int n = x;
                this.pX[n] = this.pX[n] + this.clusterWeights[i] * this.pXgivenC[x][i];
            }
        }
    }

    private void calculatePCgivenX() {
        for (int i = 0; i < this.k; ++i) {
            for (int x = 0; x < this.n; ++x) {
                this.pCgivenX[i][x] = this.pX[x] <= 0.0 ? 0.0 : this.clusterWeights[i] * this.pXgivenC[x][i] / this.pX[x];
            }
        }
    }

    private void calculateAllProbabilities() {
        this.calculateClassConditionalDensities();
        this.calculatePX();
        this.calculatePCgivenX();
    }

    private double expectation() {
        double result = 0.0;
        for (int x = 0; x < this.n; ++x) {
            result += this.pX[x];
        }
        return result;
    }

    private int[][] createProjectedClustering() {
        TreeSet<Integer> nonEmptyClusters = new TreeSet<Integer>();
        ArrayList[] clusterMemberLists = new ArrayList[this.k];
        for (int i = 0; i < this.k; ++i) {
            clusterMemberLists[i] = new ArrayList();
        }
        int maxProbIndex = 0;
        for (int x = 0; x < this.n; ++x) {
            double maxProbability = 0.0;
            for (int i = 0; i < this.k; ++i) {
                if (!(this.pCgivenX[i][x] > maxProbability)) continue;
                maxProbability = this.pCgivenX[i][x];
                maxProbIndex = i;
            }
            clusterMemberLists[maxProbIndex].add(x);
            nonEmptyClusters.add(maxProbIndex);
        }
        int[][] result = new int[nonEmptyClusters.size()][];
        int counter = 0;
        for (int i = 0; i < clusterMemberLists.length; ++i) {
            if (clusterMemberLists[i].size() <= 0) continue;
            result[counter] = new int[clusterMemberLists[i].size()];
            for (int j = 0; j < clusterMemberLists[i].size(); ++j) {
                result[counter][j] = (Integer)clusterMemberLists[i].get(j);
            }
            ++counter;
        }
        return result;
    }
}

