/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers;

import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.github.javacliparser.StringOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.SamoaToWekaInstanceConverter;
import java.util.ArrayList;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.core.AutoClassDiscovery;
import moa.core.AutoExpandVector;
import moa.core.FastVector;
import moa.core.Measurement;
import moa.options.ClassOption;
import weka.clusterers.Clusterer;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;

public class WekaClusteringAlgorithm
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    public IntOption horizonOption = new IntOption("horizon", 'h', "Range of the window.", 1000);
    public MultiChoiceOption wekaAlgorithmOption;
    public StringOption parameterOption = new StringOption("parameter", 'p', "Parameters that will be passed to the weka algorithm. (e.g. '-N 5' for using SimpleKmeans with 5 clusters)", "-N 5 -S 8");
    private Class<?>[] clustererClasses = this.findWekaClustererClasses();
    private com.yahoo.labs.samoa.instances.Instances instances;
    private weka.clusterers.AbstractClusterer clusterer;
    protected SamoaToWekaInstanceConverter instanceConverter;

    public WekaClusteringAlgorithm() {
        String[] optionLabels = new String[this.clustererClasses.length];
        String[] optionDescriptions = new String[this.clustererClasses.length];
        for (int i = 0; i < this.clustererClasses.length; ++i) {
            optionLabels[i] = this.clustererClasses[i].getSimpleName();
            optionDescriptions[i] = this.clustererClasses[i].getName();
        }
        if (this.clustererClasses != null && this.clustererClasses.length > 0) {
            this.wekaAlgorithmOption = new MultiChoiceOption("clusterer", 'w', "Weka cluster algorithm to use.", optionLabels, optionDescriptions, 6);
        } else {
            this.horizonOption = null;
            this.parameterOption = null;
        }
    }

    @Override
    public void resetLearningImpl() {
        try {
            this.instances = null;
            String clistring = this.clustererClasses[this.wekaAlgorithmOption.getChosenIndex()].getName();
            this.clusterer = (weka.clusterers.AbstractClusterer)ClassOption.cliStringToObject(clistring, Clusterer.class, null);
            String rawOptions = this.parameterOption.getValue();
            String[] options = rawOptions.split(" ");
            if (this.clusterer instanceof OptionHandler) {
                this.clusterer.setOptions(options);
                Utils.checkForRemainingOptions((String[])options);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.instanceConverter = new SamoaToWekaInstanceConverter();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.instances == null) {
            this.instances = this.getDataset(inst.numAttributes(), 0);
        }
        this.instances.add(inst);
    }

    @Override
    public Clustering getClusteringResult() {
        Clustering clustering = null;
        Instances wekaInstances = this.instanceConverter.wekaInstances(this.instances);
        try {
            this.clusterer.buildClusterer(wekaInstances);
            int numClusters = this.clusterer.numberOfClusters();
            com.yahoo.labs.samoa.instances.Instances dataset = this.getDataset(this.instances.numAttributes(), numClusters);
            ArrayList<DenseInstance> newInstances = new ArrayList<DenseInstance>();
            for (int i = 0; i < wekaInstances.numInstances(); ++i) {
                weka.core.Instance inst = wekaInstances.get(i);
                int cnum = this.clusterer.clusterInstance(inst);
                DenseInstance newInst = new DenseInstance(this.instances.instance(cnum));
                newInst.insertAttributeAt(inst.numAttributes());
                newInst.setDataset(dataset);
                newInst.setClassValue(cnum);
                newInstances.add(newInst);
            }
            clustering = new Clustering(newInstances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.instances = null;
        return clustering;
    }

    public com.yahoo.labs.samoa.instances.Instances getDataset(int numdim, int numclass) {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (int i = 0; i < numdim; ++i) {
            attributes.addElement(new Attribute("att" + (i + 1)));
        }
        if (numclass > 0) {
            FastVector<String> classLabels = new FastVector<String>();
            for (int i = 0; i < numclass; ++i) {
                classLabels.addElement("class" + (i + 1));
            }
            attributes.addElement(new Attribute("class", classLabels));
        }
        com.yahoo.labs.samoa.instances.Instances myDataset = new com.yahoo.labs.samoa.instances.Instances("horizion", attributes, 0);
        if (numclass > 0) {
            myDataset.setClassIndex(myDataset.numAttributes() - 1);
        }
        return myDataset;
    }

    private Class<?>[] findWekaClustererClasses() {
        Class[] classesFound;
        AutoExpandVector<Class> finalClasses = new AutoExpandVector<Class>();
        for (Class foundClass : classesFound = AutoClassDiscovery.findClassesOfType("weka.clusterers", weka.clusterers.AbstractClusterer.class)) {
            finalClasses.add(foundClass);
        }
        return finalClasses.toArray(new Class[finalClasses.size()]);
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return null;
    }

    @Override
    public boolean keepClassLabel() {
        return false;
    }

    @Override
    public String getPurposeString() {
        String purpose = "MOA Clusterer: " + this.getClass().getCanonicalName();
        if (this.clustererClasses == null || this.clustererClasses.length == 0) {
            purpose = purpose + "\nPlease add weka.jar to the classpath to use Weka clustering algorithms.";
        }
        return purpose;
    }
}

