/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.instancetransformers;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import com.yahoo.labs.samoa.instances.Range;
import java.util.ArrayList;
import moa.AbstractMOAObject;
import moa.classifiers.rules.multilabel.instancetransformers.InstanceTransformer;

public class InstanceOutputAttributesSelector
extends AbstractMOAObject
implements InstanceTransformer {
    private static final long serialVersionUID = 1L;
    public InstancesHeader targetInstances;
    public int[] targetOutputIndices;
    public int numSourceInstancesOutputs;

    public InstanceOutputAttributesSelector() {
    }

    public InstanceOutputAttributesSelector(InstancesHeader sourceInstances, int[] targetOutputIndices) {
        int i;
        this.targetOutputIndices = targetOutputIndices;
        this.numSourceInstancesOutputs = sourceInstances.numOutputAttributes();
        int totAttributes = sourceInstances.numInputAttributes() + this.targetOutputIndices.length;
        this.targetInstances = new InstancesHeader();
        ArrayList<Attribute> v = new ArrayList<Attribute>(totAttributes);
        ArrayList<Integer> indexValues = new ArrayList<Integer>(totAttributes);
        int numInputs = sourceInstances.numInputAttributes();
        for (i = 0; i < numInputs; ++i) {
            v.add(sourceInstances.inputAttribute(i));
            indexValues.add(i);
        }
        for (i = 0; i < this.targetOutputIndices.length; ++i) {
            v.add(sourceInstances.outputAttribute(this.targetOutputIndices[i]));
            indexValues.add(numInputs + i);
        }
        this.targetInstances.setAttributes(v, indexValues);
        Range r = new Range("-" + targetOutputIndices.length);
        r.setUpper(totAttributes);
        this.targetInstances.setRangeOutputIndices(r);
    }

    @Override
    public Instance sourceInstanceToTarget(Instance sourceInstance) {
        int i;
        double[] attValues = new double[this.targetInstances.numAttributes()];
        InstanceImpl newInstance = new InstanceImpl(sourceInstance.weight(), attValues);
        int numInputs = this.targetInstances.numInputAttributes();
        for (i = 0; i < numInputs; ++i) {
            newInstance.setValue(i, sourceInstance.valueInputAttribute(i));
        }
        for (i = 0; i < this.targetOutputIndices.length; ++i) {
            newInstance.setValue(numInputs + i, sourceInstance.valueOutputAttribute(this.targetOutputIndices[i]));
        }
        newInstance.setDataset(this.targetInstances);
        return newInstance;
    }

    @Override
    public Prediction targetPredictionToSource(Prediction targetPrediction) {
        MultiLabelPrediction sourcePrediction = new MultiLabelPrediction(this.numSourceInstancesOutputs);
        for (int i = 0; i < targetPrediction.numOutputAttributes(); ++i) {
            sourcePrediction.setVotes(this.targetOutputIndices[i], targetPrediction.getVotes(i));
        }
        return sourcePrediction;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

