/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.functions;

import com.github.javacliparser.FloatOption;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.rules.functions.AMRulesRegressorFunction;
import moa.core.Measurement;
import moa.core.StringUtils;

public class TargetMean
extends AbstractClassifier
implements AMRulesRegressorFunction {
    protected double n;
    protected double sum;
    protected double errorSum;
    protected double nError;
    private double fadingErrorFactor;
    private static final long serialVersionUID = 7152547322803559115L;
    public FloatOption fadingErrorFactorOption = new FloatOption("fadingErrorFactor", 'e', "Fading error factor for the TargetMean accumulated error", 0.99, 0.0, 1.0);

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] currentMean = new double[]{this.n > 0.0 ? this.sum / this.n : 0.0};
        return currentMean;
    }

    @Override
    public void resetLearningImpl() {
        this.sum = 0.0;
        this.n = 0.0;
        this.errorSum = Double.MAX_VALUE;
        this.nError = 0.0;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.updateAccumulatedError(inst);
        this.n += inst.weight();
        this.sum += inst.classValue() * inst.weight();
    }

    protected void updateAccumulatedError(Instance inst) {
        double mean = 0.0;
        this.nError = inst.weight() + this.fadingErrorFactor * this.nError;
        if (this.n > 0.0) {
            mean = this.sum / this.n;
        }
        this.errorSum = Math.abs(inst.classValue() - mean) * inst.weight() + this.fadingErrorFactor * this.errorSum;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        StringUtils.appendIndented(out, indent, "Current Mean: " + this.sum / this.n);
        StringUtils.appendNewline(out);
    }

    public void reset(double currentMean, double numberOfInstances) {
        this.sum = currentMean * numberOfInstances;
        this.n = numberOfInstances;
        this.resetError();
    }

    @Override
    public double getCurrentError() {
        if (this.nError > 0.0) {
            return this.errorSum / this.nError;
        }
        return Double.MAX_VALUE;
    }

    public TargetMean(TargetMean t) {
        this.n = t.n;
        this.sum = t.sum;
        this.errorSum = t.errorSum;
        this.nError = t.nError;
        this.fadingErrorFactor = t.fadingErrorFactor;
        this.fadingErrorFactorOption = t.fadingErrorFactorOption;
    }

    public TargetMean() {
        this.fadingErrorFactor = this.fadingErrorFactorOption.getValue();
    }

    public void resetError() {
        this.errorSum = 0.0;
        this.nError = 0.0;
    }
}

