/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.splitcriteria;

import moa.classifiers.core.splitcriteria.VarianceReductionSplitCriterion;
import moa.classifiers.rules.core.splitcriteria.AMRulesSplitCriterion;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class VarianceRatioSplitCriterion
extends AbstractOptionHandler
implements AMRulesSplitCriterion {
    private static final long serialVersionUID = -1066043659710778883L;

    @Override
    public double[] computeBranchSplitMerits(double[][] postSplitDists) {
        double Ni;
        int i;
        double[] SDR = new double[postSplitDists.length];
        double N = 0.0;
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            N += Ni;
        }
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            SDR[i] = VarianceReductionSplitCriterion.computeSD(postSplitDists[i]);
        }
        return SDR;
    }

    @Override
    public double getMeritOfSplit(double[] preSplitDist, double[][] postSplitDists) {
        double N = preSplitDist[0];
        int count = 0;
        for (int i = 0; i < postSplitDists.length; ++i) {
            double Ni = postSplitDists[i][0];
            if (!(Ni >= 0.05 * preSplitDist[0])) continue;
            ++count;
        }
        if (count == postSplitDists.length) {
            double SDR = VarianceReductionSplitCriterion.computeSD(preSplitDist);
            double sumPostSDR = 0.0;
            for (int i = 0; i < postSplitDists.length; ++i) {
                double Ni = postSplitDists[i][0];
                sumPostSDR += Ni / N * VarianceReductionSplitCriterion.computeSD(postSplitDists[i]);
            }
            return 1.0 - sumPostSDR / (double)postSplitDists.length / SDR;
        }
        return -1.7976931348623157E308;
    }

    @Override
    public double getRangeOfMerit(double[] preSplitDist) {
        return 1.0;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

