/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy.neighboursearch.kdtrees;

import moa.classifiers.lazy.neighboursearch.kdtrees.KDTreeNode;
import moa.classifiers.lazy.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class SlidingMidPointOfWidestSide
extends KDTreeNodeSplitter {
    private static final long serialVersionUID = 852857628205680562L;
    protected static double ERR = 0.001;

    public String globalInfo() {
        return "The class that splits a node into two based on the midpoint value of the dimension in which the node's rectangle is widest. If after splitting one side is empty then it is slided towards the non-empty side until there is at least one point on the empty side.\n\nFor more information see also:\n\n";
    }

    @Override
    public void splitNode(KDTreeNode node, int numNodesCreated, double[][] nodeRanges, double[][] universe) throws Exception {
        double tempval;
        int i;
        this.correctlyInitialized();
        if (node.m_NodesRectBounds == null) {
            node.m_NodesRectBounds = new double[2][node.m_NodeRanges.length];
            for (int i2 = 0; i2 < node.m_NodeRanges.length; ++i2) {
                node.m_NodesRectBounds[0][i2] = node.m_NodeRanges[i2][0];
                node.m_NodesRectBounds[1][i2] = node.m_NodeRanges[i2][1];
            }
        }
        double maxRectWidth = Double.NEGATIVE_INFINITY;
        double maxPtWidth = Double.NEGATIVE_INFINITY;
        int splitDim = -1;
        int classIdx = this.m_Instances.classIndex();
        for (i = 0; i < node.m_NodesRectBounds[0].length; ++i) {
            if (i == classIdx) continue;
            tempval = node.m_NodesRectBounds[1][i] - node.m_NodesRectBounds[0][i];
            if (this.m_NormalizeNodeWidth) {
                tempval /= universe[i][2];
            }
            if (!(tempval > maxRectWidth) || !(node.m_NodeRanges[i][2] > 0.0)) continue;
            maxRectWidth = tempval;
        }
        for (i = 0; i < node.m_NodesRectBounds[0].length; ++i) {
            if (i == classIdx) continue;
            tempval = node.m_NodesRectBounds[1][i] - node.m_NodesRectBounds[0][i];
            if (this.m_NormalizeNodeWidth) {
                tempval /= universe[i][2];
            }
            if (!(tempval >= maxRectWidth * (1.0 - ERR)) || !(node.m_NodeRanges[i][2] > 0.0) || !(node.m_NodeRanges[i][2] > maxPtWidth)) continue;
            maxPtWidth = node.m_NodeRanges[i][2];
            if (this.m_NormalizeNodeWidth) {
                maxPtWidth /= universe[i][2];
            }
            splitDim = i;
        }
        double splitVal = node.m_NodesRectBounds[0][splitDim] + (node.m_NodesRectBounds[1][splitDim] - node.m_NodesRectBounds[0][splitDim]) * 0.5;
        if (splitVal < node.m_NodeRanges[splitDim][0]) {
            splitVal = node.m_NodeRanges[splitDim][0];
        } else if (splitVal >= node.m_NodeRanges[splitDim][1]) {
            splitVal = node.m_NodeRanges[splitDim][1] - node.m_NodeRanges[splitDim][2] * 0.001;
        }
        int rightStart = this.rearrangePoints(this.m_InstList, node.m_Start, node.m_End, splitDim, splitVal);
        if (rightStart == node.m_Start || rightStart > node.m_End) {
            if (rightStart == node.m_Start) {
                throw new Exception("Left child is empty in node " + node.m_NodeNumber + ". Not possible with SlidingMidPointofWidestSide splitting method. Please check code.");
            }
            throw new Exception("Right child is empty in node " + node.m_NodeNumber + ". Not possible with SlidingMidPointofWidestSide splitting method. Please check code.");
        }
        node.m_SplitDim = splitDim;
        node.m_SplitValue = splitVal;
        double[][] widths = new double[2][node.m_NodesRectBounds[0].length];
        System.arraycopy(node.m_NodesRectBounds[0], 0, widths[0], 0, node.m_NodesRectBounds[0].length);
        System.arraycopy(node.m_NodesRectBounds[1], 0, widths[1], 0, node.m_NodesRectBounds[1].length);
        widths[1][splitDim] = splitVal;
        node.m_Left = new KDTreeNode(numNodesCreated + 1, node.m_Start, rightStart - 1, this.m_EuclideanDistance.initializeRanges(this.m_InstList, node.m_Start, rightStart - 1), widths);
        widths = new double[2][node.m_NodesRectBounds[0].length];
        System.arraycopy(node.m_NodesRectBounds[0], 0, widths[0], 0, node.m_NodesRectBounds[0].length);
        System.arraycopy(node.m_NodesRectBounds[1], 0, widths[1], 0, node.m_NodesRectBounds[1].length);
        widths[0][splitDim] = splitVal;
        node.m_Right = new KDTreeNode(numNodesCreated + 2, rightStart, node.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, rightStart, node.m_End), widths);
    }

    protected int rearrangePoints(int[] indices, int startidx, int endidx, int splitDim, double splitVal) {
        int left = startidx - 1;
        for (int i = startidx; i <= endidx; ++i) {
            if (!this.m_EuclideanDistance.valueIsSmallerEqual(this.m_Instances.instance(indices[i]), splitDim, splitVal)) continue;
            int tmp = indices[++left];
            indices[left] = indices[i];
            indices[i] = tmp;
        }
        return left + 1;
    }
}

