/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.InstanceData;

public class DenseInstanceData
implements InstanceData {
    protected double[] attributeValues;

    public DenseInstanceData(double[] array) {
        this.attributeValues = array;
    }

    public DenseInstanceData(int length) {
        this.attributeValues = new double[length];
    }

    public DenseInstanceData() {
        this(0);
    }

    @Override
    public int numAttributes() {
        return this.attributeValues.length;
    }

    @Override
    public double value(int indexAttribute) {
        return this.attributeValues[indexAttribute];
    }

    @Override
    public boolean isMissing(int indexAttribute) {
        return Double.isNaN(this.value(indexAttribute));
    }

    @Override
    public int numValues() {
        return this.numAttributes();
    }

    @Override
    public int index(int indexAttribute) {
        return indexAttribute;
    }

    @Override
    public double valueSparse(int indexAttribute) {
        return this.value(indexAttribute);
    }

    @Override
    public boolean isMissingSparse(int indexAttribute) {
        return this.isMissing(indexAttribute);
    }

    @Override
    public double[] toDoubleArray() {
        return (double[])this.attributeValues.clone();
    }

    @Override
    public void setValue(int attributeIndex, double d) {
        this.attributeValues[attributeIndex] = d;
    }

    @Override
    public void deleteAttributeAt(int index) {
        double[] newValues = new double[this.attributeValues.length - 1];
        System.arraycopy(this.attributeValues, 0, newValues, 0, index);
        if (index < this.attributeValues.length - 1) {
            System.arraycopy(this.attributeValues, index + 1, newValues, index, this.attributeValues.length - (index + 1));
        }
        this.attributeValues = newValues;
    }

    @Override
    public void insertAttributeAt(int index) {
        if (index < 0 || index > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        double[] newValues = new double[this.attributeValues.length + 1];
        System.arraycopy(this.attributeValues, 0, newValues, 0, index);
        newValues[index] = Double.NaN;
        System.arraycopy(this.attributeValues, index, newValues, index + 1, this.attributeValues.length - index);
        this.attributeValues = newValues;
    }

    @Override
    public InstanceData copy() {
        return new DenseInstanceData((double[])this.attributeValues.clone());
    }
}

