/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser.gui;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.Option;
import com.github.javacliparser.gui.OptionEditComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import moa.gui.FileExtensionFilter;

public class FileOptionEditComponent
extends JPanel
implements OptionEditComponent {
    private static final long serialVersionUID = 1L;
    protected FileOption editedOption;
    protected JTextField textField = new JTextField();
    protected JButton browseButton = new JButton("Browse");

    public FileOptionEditComponent(Option opt) {
        FileOption option;
        this.editedOption = option = (FileOption)opt;
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.browseButton, "East");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileOptionEditComponent.this.browseForFile();
            }
        });
        this.setEditState(this.editedOption.getValueAsCLIString());
    }

    @Override
    public void applyState() {
        this.editedOption.setValueViaCLIString(this.textField.getText().length() > 0 ? this.textField.getText() : null);
    }

    @Override
    public Option getEditedOption() {
        return this.editedOption;
    }

    @Override
    public void setEditState(String cliString) {
        this.textField.setText(cliString);
    }

    public void browseForFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        String extension = this.editedOption.getDefaultFileExtension();
        if (extension != null) {
            fileChooser.addChoosableFileFilter(new FileExtensionFilter(extension));
        }
        fileChooser.setSelectedFile(new File(this.textField.getText()));
        if (this.editedOption.isOutputFile()) {
            if (fileChooser.showSaveDialog(this.browseButton) == 0) {
                File chosenFile = fileChooser.getSelectedFile();
                String fileName = chosenFile.getPath();
                if (!chosenFile.exists() && extension != null && !fileName.endsWith(extension)) {
                    fileName = fileName + "." + extension;
                }
                this.textField.setText(fileName);
            }
        } else if (fileChooser.showOpenDialog(this.browseButton) == 0) {
            this.textField.setText(fileChooser.getSelectedFile().getPath());
        }
    }
}

