% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_proposal_votes.R
\name{get_proposal_votes}
\alias{get_proposal_votes}
\title{Retreive all votes for a specified vote proposal}
\usage{
get_proposal_votes(voteid = NA, good_manners = 0)
}
\arguments{
\item{voteid}{Character string indicating the id of the vote to request all votes from}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A list with two elements:
\enumerate{
\item \strong{$proposal_vote} (main data on the vote proposal)\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{vote_id} \tab Id of the vote \cr
}

\item \strong{$proposal_by_parties${proposal_id}} (what parties (id) stood behind proposal(s))
}
}
\description{
A function for retrieving all votes from a specific vote proposal. Vote data are only available from the 2011-2012 session
}
\examples{

\dontrun{

prop <- get_proposal_votes(7523)
prop

for(i in 1:length(prop$proposal_by_parties)){
    prop$proposal_vote$parties[i] <- paste0(prop$proposal_by_parties[[i]], 
                                            collapse = ", ")

}

}


}
\seealso{
\link{get_vote} \link{get_decision_votes} \link{get_result_vote}
}
