% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_mp_speech_activity.R
\name{get_session_mp_speech_activity}
\alias{get_session_mp_speech_activity}
\title{Retrieve all speech activity from one MP for a given session}
\usage{
get_session_mp_speech_activity(sessionid = NA, mp_id = NA, good_manners = 0)
}
\arguments{
\item{sessionid}{Character string indicating the session to retrieve speeches from.}

\item{mp_id}{Character string for the MP to retreive all speeches of in a given session.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{session_id} \tab Session id \cr
   \strong{agenda_case_number} \tab Number indicating the agenda number for the case \cr
   \strong{meeting_id} \tab Meeting id \cr
   \strong{speech_start_time} \tab Start time of speech \cr
   \strong{speech_type} \tab Type of speech \cr
   \strong{speech_length_secs} \tab Lenght of speech in seconds \cr
}
}
\description{
A function for retrieving all speech activity from an MP during a specific parliamentary session.
Only available from the 2011-2012 session and onwards.
}
\examples{

\dontrun{

activ <- get_session_mp_speech_activity("2012-2013", "ALYS")
head(activ)
}


}
\seealso{
\link{get_mp} \link{get_mp_bio} \link{get_publication}
}
