% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_rpowerstress.R
\name{stop_rpowerstress}
\alias{stop_rpowerstress}
\title{STOPS version of restricted powerstress}
\usage{
stop_rpowerstress(
  dis,
  theta = c(1, 1, 1),
  type = "ratio",
  weightmat = NULL,
  init = NULL,
  ndim = 2,
  itmaxi = 10000,
  ...,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  stoptype = c("additive", "multiplicative"),
  registry = struc_reg
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; the first two arguments are for kappa and lambda and should be equal (for the fitted distances and observed proximities), the third nu (for the weights). Internally the kappa and lambda are equated. If a scalar is given it is recycled (so all elements of theta are equal); if a vector of length 2 is given, it gets expanded to c(theta[1],theta[1],theta[2]). Defaults to 1 1 1.}

\item{type}{MDS type. Defaults to "ratio".}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{init}{(optional) initial configuration}

\item{ndim}{number of dimensions of the target space}

\item{itmaxi}{number of iterations. default is 10000.}

\item{...}{additional arguments to be passed to the fitting procedure powerStressMin}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{a character vector listing the structure indices to use. They always are called "cfoo" with foo being the structure.}

\item{strucweight}{weight to be used for the structures; defaults to 1/number of structures}

\item{strucpars}{a list of list of parameters for the structuredness indices; each list element corresponds to one index in the order of the appearance in structures vector. See examples.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{stoptype}{which weighting to be used in the multi-objective optimization? Either 'additive' (default) or 'multiplicative'.}

\item{registry}{registry object with c-structuredness indices.}
}
\value{
A list with the components
\itemize{
        \item stress: the stress-1 value
        \item stress.m: default normalized stress
        \item stoploss: the weighted loss value
        \item struc: the structuredness indices
        \item parameters: the parameters used for fitting (kappa=lambda, nu)
        \item fit: the returned object of the fitting procedure
         \item{stopobj:} the stopobj object 
}
}
\description{
STOPS version of restricted powerstress
}
\keyword{multivariate}
