% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structurednessindices.R
\name{c_complexity}
\alias{c_complexity}
\title{c-complexity
Calculates the c-complexity based on the minimum cell number
We define c-complexity as the aggregated minimum cell number between any two columns in confs 
This is one of few c-structuredness indices not between 0 and 1, but can be between 0 and (theoretically) infinity}
\usage{
c_complexity(
  confs,
  aggr = NULL,
  alpha = 1,
  C = 15,
  var.thr = 1e-05,
  zeta = NULL
)
}
\arguments{
\item{confs}{a numeric matrix or data frame}

\item{aggr}{the aggregation function for configurations of more than two dimensions. Defaults to min.}

\item{alpha}{an optional number of cells allowed in the X-by-Y search-grid. Default value is 1}

\item{C}{an optional number determining the starting point of the X-by-Y search-grid. When trying to partition the x-axis into X columns, the algorithm will start with at most C X clumps. Default value is 15.}

\item{var.thr}{minimum value allowed for the variance of the input variables, since mine can not be computed in case of variance close to 0. Default value is 1e-5.}

\item{zeta}{integer in [0,1] (?).  If NULL (default) it is set to 1-MIC. It can be set to zero for noiseless functions, but the default choice is the most appropriate parametrization for general cases (as stated in Reshef et al.). It provides robustness.}
}
\value{
a numeric value; complexity (aggregated minimum cell number MCN, see \code{\link[minerva]{mine}})
}
\description{
c-complexity
Calculates the c-complexity based on the minimum cell number
We define c-complexity as the aggregated minimum cell number between any two columns in confs 
This is one of few c-structuredness indices not between 0 and 1, but can be between 0 and (theoretically) infinity
}
\examples{
x<-seq(-3,3,length.out=200)
y<-sqrt(3^2-x^2)
z<- sin(y-x)
confs<-cbind(x,y,z)
c_complexity(confs)
}
