% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_chr.R, R/stabilize_chr_scalar.R,
%   R/to_chr.R, R/to_chr_scalar.R
\name{stabilize_chr}
\alias{stabilize_chr}
\alias{stabilize_chr_scalar}
\alias{to_chr}
\alias{to_chr_scalar}
\title{Ensure a character argument meets expectations}
\usage{
stabilize_chr(
  x,
  ...,
  allow_null = TRUE,
  allow_na = TRUE,
  min_size = NULL,
  max_size = NULL,
  regex = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

stabilize_chr_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  regex = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_chr(
  x,
  allow_null = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_chr_scalar(
  x,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{...}{These dots are for future extensions and should be empty.}

\item{allow_null}{Logical. Is NULL an acceptable value?}

\item{allow_na}{Logical. Are NA values ok?}

\item{min_size}{Integer. The minimum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{Integer. The maximum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{regex}{Character scalar. An optional regex pattern to compare the
value(s) of \code{x} against. If a complex regex pattern throws an error, try
installing the stringi package with \code{install.packages("stringi")}.}

\item{x_arg}{Character. An argument name for x. The automatic value will work
in most cases, or pass it through from higher-level functions to make error
messages clearer in unexported functions.}

\item{call}{The execution environment of the call. See the \code{call} argument of
\code{rlang::abort()} for more information.}

\item{x_class}{Character. The class name of \code{x} to use in error messages. Use
this if you remove a special class from \code{x} before checking its coercion,
but want the error message to match the original class.}

\item{allow_zero_length}{Logical. Are zero-length vectors acceptable?}
}
\value{
The argument as a character vector.
}
\description{
\code{to_chr()} checks whether an argument can be coerced to
character without losing information, returning it silently if so.
Otherwise an informative error message is signaled.

\code{stabilize_chr()} can check more details about the argument, but is slower
than \code{to_chr()}.

\code{stabilize_chr_scalar()} and \code{to_chr_scalar()} are optimized to check for
length-1 character vectors.
}
\details{
These functions have two important differences from
\code{\link[base:character]{base::as.character()}}:
\itemize{
\item \code{list}s and \code{data.frame}s are \emph{not} coerced to character. In base R, such
objects are coerced to character representations of their elements. For
example, \code{as.character(list(1:3))} returns "1:10". In the unlikely event
that this is the expected behavior, use \code{as.character()} instead.
\item \code{NULL} values can be rejected as part of the call to this function (with
\code{allow_null = FALSE}).
}
}
\examples{
to_chr("a")
to_chr(letters)
to_chr(1:10)
to_chr(1 + 0i)
to_chr(NULL)
try(to_chr(NULL, allow_null = FALSE))

to_chr_scalar("a")
try(to_chr_scalar(letters))

stabilize_chr(letters)
stabilize_chr(1:10)
stabilize_chr(NULL)
try(stabilize_chr(NULL, allow_null = FALSE))
try(stabilize_chr(c("a", NA), allow_na = FALSE))
try(stabilize_chr(letters, min_size = 50))
try(stabilize_chr(letters, max_size = 20))
try(stabilize_chr(c("hide", "find", "find", "hide"), regex = "hide"))

stabilize_chr_scalar(TRUE)
stabilize_chr_scalar("TRUE")
try(stabilize_chr_scalar(c(TRUE, FALSE, TRUE)))
stabilize_chr_scalar(NULL)
try(stabilize_chr_scalar(NULL, allow_null = FALSE))
}
