% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/set.R
\name{discard_if}
\alias{discard_if}
\alias{discard_if_}
\title{Create new data.table after discarding certain rows}
\usage{
discard_if(x, ..., by = NULL)

discard_if_(x, .dots, by = NULL)
}
\arguments{
\item{x}{a data.table}

\item{...}{Conditions. Rows where the condition evaluates to NA are not discardd. Therefore, \code{discard_if(dt, condition)} is not the same as \code{keep_if(x, !condition)} with}

\item{by}{groups in which the condition should be evaluated}

\item{.dots}{Used to work around non-standard evaluation.}
}
\description{
Create new data.table after discarding certain rows
}
\examples{
library(data.table)
DT <- data.table(
  id = c(1,2,1),
  v1 = c(1,NA,2)
)
discard_if(DT, v1 == 1)
discard_if(DT, v1 == 1, v1 == 2)
discard_if(DT, v1 == min(v1), by = id)
}

