% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/count_combinations.R
\name{compute_distance}
\alias{compute_distance}
\title{Find minimum distance of each word to other groups}
\usage{
compute_distance(name, id, n = 1, method = "jw", p = 0.1, ...)
}
\arguments{
\item{name}{a vector of characters}

\item{id}{a vector of identifiers}

\item{n}{number of words for combinations. Default to \code{0}.}

\item{method}{See the \code{\link[stringdist]{stringdist}} documentation. Default to \code{"jw"}}

\item{p}{See  the \code{\link[stringdist]{stringdist}} documentation. Default to \code{0.1}}

\item{...}{Other arguments to pass to \code{stringdist}. See the \code{\link[stringdist]{stringdist}} documentation.}
}
\value{
\code{tab_accross} returns a data.frame of four columns. The first is id, the second corresponds to unique combination of words in each element of \code{v} with length lower than \code{n} (sorted alphabetically),  the third is the count of these permutation within \code{id}, the fourth is the count of these permutation accross \code{i}. When the count accross group is 1 and the count within group is high, the element can be considered as an identifier of the group.
id <- c(1, 1, 2, 2)
name <- c("coca cola company", "coca cola incorporated", "apple incorporated", "apple corp")
compute_distance(name, id, n = 0)
compute_distance(name, id, n = 1)
compute_distance(name, id, n = 2)
}
\description{
Find minimum distance of each word to other groups
}

