% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{eem_getextreme}
\alias{eem_getextreme}
\title{Determines the the biggest range of EEM spectrum where data is available from each sample.}
\usage{
eem_getextreme(data)
}
\arguments{
\item{data}{eemlist}
}
\value{
list of numeric vector containing the biggest available range
}
\description{
Determines the the biggest range of EEM spectrum where data is available from each sample.
}
\examples{
data(eem_list)
eem_getextreme(eem_list)

eem_list <- eem_range(eem_list,ex = c(250,Inf),em = c(280,500))
eem_getextreme(eem_list)
}
