% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_ssc}
\alias{eempf_ssc}
\title{Calculate the shift-and shape-sensitive congruence (SSC) between model components}
\usage{
eempf_ssc(pf_models, tcc = FALSE, m = FALSE)
}
\arguments{
\item{pf_models}{list of either PARAFAC models or component matrices}

\item{tcc}{if set TRUE, TCC is returned instead}

\item{m}{logical, if TRUE, emission and excitation SSCs or TCCs are combined by calculating the geometric mean}
}
\value{
(list of) tables containing SCCs between components
}
\description{
The data variable pf_models can be supplied as list of PARAFAC models, output from a splithalf analysis or list of matrices
Please see details of calculation in:
U.J. Wünsch, R. Bro, C.A. Stedmon, P. Wenig, K.R. Murphy, Emerging patterns in the global distribution of dissolved matter fluorescence, Anal. Methods, 11 (2019), pp. 888-893
}
\examples{
pf_models <- pf3[1:3]

sscs <- eempf_ssc(pf_models)
sscs

tcc <- eempf_ssc(pf_models, tcc = TRUE)
tcc
## mixed tcc (combine em and ex)
mtcc <- eempf_ssc(pf_models, tcc = TRUE, m = TRUE)
mtcc

## compare results from splithalf analysis
sh_sscs <- eempf_ssc(sh)

sh_sscs
## view diagonals only (components with similar numbers only)
lapply(sh_sscs, lapply, diag)

}
