% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCA_helpers.R
\name{sparsity_mixed}
\alias{sparsity_mixed}
\title{Mixed Sparsity of the Loadings}
\usage{
sparsity_mixed(PC, p, N, k = 1, tolerance = 0.001, mean = "arithmetic")
}
\arguments{
\item{PC}{matrix-like object of PCs.}

\item{p}{integer, number of variables.}

\item{N}{integer, number of groups.}

\item{k}{integer, which components should be used. Does not work for multiple PCs simultaneously.}

\item{tolerance}{tolerance for sparsity.}

\item{mean}{if \code{"arithmetic"} or \code{"geometric"} mean should be used.}
}
\value{
Returns the geometric mean of the percentage of entry-wise and group-wise sparsity.
}
\description{
Mixed Sparsity of the Loadings
}
\examples{
PC = matrix(c(1,0,2,3,0,7,0,1,0,1,0.001,0), ncol = 2)
sparsity_mixed(PC, N = 2, p = 3, tolerance = 0, k = 1)
sparsity_mixed(PC, N = 2, p = 3, tolerance = 0.001, k = 2, mean = "geometric")
}
