% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc_methods.R
\name{biplot.PCAloc}
\alias{biplot.PCAloc}
\title{Biplot for PCAloc}
\usage{
\method{biplot}{PCAloc}(x, ...)
}
\arguments{
\item{x}{object of class PCAloc.}

\item{...}{other input arguments, see details.}
}
\value{
Returns version of biplot for PCAloc object.
}
\description{
Biplot for PCAloc
}
\details{
Additional parameters that can be given to the function are: \tabular{ll}{
   \code{shape} \tab point shape  \cr
   \tab \cr
   \code{size} \tab point size \cr
   \tab \cr
   \code{alpha} \tab transparency  \cr
   \tab \cr
   \code{color} \tab either \code{"variable"} or \code{"groups"}
   indication how points should be coloured.   \cr
   \tab \cr
}
}
\examples{
# set seed
set.seed(236)

# make data
data = matrix(rnorm(2000), ncol = 4)
groups = sample(1:10, 500, replace = TRUE)
W = time_weights(N = 10, c(3,2,1))

# calculate covariance matrices
covs = ssMRCD(data, groups = groups, weights = W, lambda = 0.3)

# sparse PCA
pca = sparsePCAloc(eta = 0.3, gamma = 0.7, cor = FALSE, COVS = covs$MRCDcov,
             n_max = 1000, increase_rho = list(TRUE, 50, 1), trace = FALSE)

# plot biplot
biplot(pca, alpha = 0.4, shape = 16, size = 2, color = "variable")
}
