% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-transformations.R
\name{qts2avts}
\alias{qts2avts}
\title{QTS Transformation to Angular Velocity Time Series}
\usage{
qts2avts(x, body_frame = FALSE)
}
\arguments{
\item{x}{An object of class \link{qts}.}

\item{body_frame}{A boolean specifying whether the fixed frame with respect
to which coordinates of the angular velocity should be computed is the body
frame or the global frame. Defaults to \code{FALSE}.}
}
\value{
A time series stored as a \link[tibble:tibble]{tibble::tibble} with columns \code{time}, \code{x},
\code{y} and \code{z} containing the angular velocity at each time point.
}
\description{
This function projects a quaternion time series into the space of angular
velocities.
}
\examples{
qts2avts(vespa64$igp[[1]])
}
