#' \code{squashinformr} package
#'
#' The squashinformr package allows sports enthusiasts to easily access data related to the Professional Squash Association's World Tour and other squash tournaments from SquashInfo. The functions within this package scrape, parse, and clean data associated with players, tournaments, and rankings data.
#'
#' See the README on \href{https://github.com/HaydenMacDonald/squashinformr}{GitHub}
#'
#' @docType package
#' @name squashinformr
NULL

## quiets concerns of R CMD check re: the .'s that appear in pipelines
if(getRversion() >= "3.4.0")  utils::globalVariables(c(".",
                                                       "g",
                                                       "hwr",
                                                       "name",
                                                       "gender",
                                                       "ranking_month",
                                                       "ranking_year",
                                                       "exact_date",
                                                       "Rank",
                                                       "Name",
                                                       "Year",
                                                       "rnd",
                                                       "ctry",
                                                       "w_l",
                                                       "opponent",
                                                       "score",
                                                       "match_time",
                                                       "points_won",
                                                       "points_lost",
                                                       "game_result",
                                                       "event",
                                                       "country",
                                                       "psa",
                                                       "result",
                                                       "games_won",
                                                       "games_lost",
                                                       "seeding",
                                                       "tour",
                                                       "round_reached",
                                                       "event_date",
                                                       "rowid",
                                                       "value",
                                                       "age",
                                                       "birthplace",
                                                       "residence",
                                                       "height",
                                                       "weight",
                                                       "plays",
                                                       "racket",
                                                       "joined_psa",
                                                       "coach",
                                                       "university",
                                                       "club",
                                                       "prev",
                                                       "previous_rank",
                                                       "highest_world_ranking",
                                                       "hwr_date",
                                                       "highest_ranking",
                                                       "x",
                                                       "league",
                                                       "setNames",
                                                       "X1",
                                                       "X2",
                                                       "player_1",
                                                       "player_2",
                                                       "tournament_name",
                                                       "tournament_date",
                                                       "match_winner",
                                                       "player_1_seed",
                                                       "player_2_seed",
                                                       "player_1_nationality",
                                                       "player_2_nationality",
                                                       "player_1_score",
                                                       "player_2_score",
                                                       "category",
                                                       "games",
                                                       "games_won",
                                                       "games_lost",
                                                       "player",
                                                       "player_seed",
                                                       "seed",
                                                       "city",
                                                       "game",
                                                       "game_winner",
                                                       "player_nationality",
                                                       "nationality",
                                                       "opponent_rank",
                                                       "get_matchup",
                                                       "player_1",
                                                       "player_2",
                                                       "opponent_rank",
                                                       "player_1_rank",
                                                       "player_2_rank",
                                                       "player_1_advantage",
                                                       "player_2_advantage",
                                                       "point_diff",
                                                       "month",
                                                       "location",
                                                       "vars",
                                                       "Jan",
                                                       "Feb",
                                                       "Mar",
                                                       "Apr",
                                                       "May",
                                                       "Jun",
                                                       "Jul",
                                                       "Aug",
                                                       "Sep",
                                                       "Oct",
                                                       "Nov",
                                                       "Dec",
                                                       "matches_0_3",
                                                       "matches_1_3",
                                                       "matches_2_3",
                                                       "matches_3_0",
                                                       "matches_3_1",
                                                       "matches_3_2"))
