\name{cdf.test}
\alias{cdf.test}
\title{Cumulative Distribution Function - Inference}
\description{
  This function tests for differences between cumulative distribution functions
  (CDFs) generated by probability surveys.  The function returns a variety of
  test statistics along with their degrees of freedom and p values.
}
\usage{
cdf.test(bounds, z_1, wgt_1, x_1=NULL, y_1=NULL, z_2, wgt_2, x_2=NULL, y_2=NULL,
  stratum_1=NULL, stratum_2=NULL, cluster_1=NULL, cluster_2=NULL, wgt1_1=NULL,
  x1_1=NULL, y1_1=NULL, wgt1_2=NULL, x1_2=NULL, y1_2=NULL, popsize_1=NULL,
  popsize_2=NULL, popcorrect_1=FALSE, pcfsize_1=NULL, N.cluster_1=NULL,
  stage1size_1=NULL, support_1=NULL, popcorrect_2=FALSE, pcfsize_2=NULL,
  N.cluster_2=NULL, stage1size_2=NULL, support_2=NULL, sizeweight_1=FALSE,
  swgt_1=NULL, swgt1_1=NULL, sizeweight_2=FALSE, swgt_2=NULL, swgt1_2=NULL,
  vartype_1="Local", vartype_2="Local", check.ind=TRUE, warn.ind=NULL,
  warn.df=NULL, warn.vec=NULL)
}
\arguments{
  \item{bounds}{vector of upper bounds that define classes for the CDFs, which must
    contain at least two values.}
  \item{z_1}{response value for each sample one site.}
  \item{wgt_1}{final adjusted weight (inverse of the sample inclusion
    probability) for each sample one site, which is either the weight for a
    single-stage sample or the stage two weight for a two-stage sample.}
  \item{x_1}{x-coordinate for location for each sample one site, which is either
    the x-coordinate for a single-stage sample or the stage two x-coordinate for
    a two-stage sample.  The default is NULL.}
  \item{y_1}{y-coordinate for location for each sample one site, which is either
    the y-coordinate for a single-stage sample or the stage two y-coordinate for
    a two-stage sample.  The default is NULL.}
  \item{z_2}{response value for each sample two site.}
  \item{wgt_2}{final adjusted weight (inverse of the sample inclusion
    probability) for each sample two site, which is either the weight for a
    single-stage sample or the stage two weight for a two-stage sample.}
  \item{x_2}{x-coordinate for location for each sample two site, which is either
    the x-coordinate for a single-stage sample or the stage two x-coordinate for
    a two-stage sample.  The default is NULL.}
  \item{y_2}{y-coordinate for location for each sample two site, which is either
    the y-coordinate for a single-stage sample or the stage two y-coordinate for
    a two-stage sample.  The default is NULL.}
  \item{stratum_1}{the stratum for each sample one site.  The default is NULL.}
  \item{stratum_2}{the stratum for each sample two site.  The default is NULL.}
  \item{cluster_1}{the stage one sampling unit (primary sampling unit or
    cluster) code for each sample one site.  The default is NULL.}
  \item{cluster_2}{the stage one sampling unit (primary sampling unit or
    cluster) code for each sample two site.  The default is NULL.}
  \item{wgt1_1}{the final adjusted stage one weight for each sample one site.
    The default is NULL.}
  \item{x1_1}{the stage one x-coordinate for location for each sample one site.
    The default is NULL.}
  \item{y1_1}{the stage one y-coordinate for location for each sample one site.
    The default is NULL.}
  \item{wgt1_2}{the final adjusted stage one weight for each sample two site.
    The default is NULL.}
  \item{x1_2}{the stage one x-coordinate for location for each sample two site.
    The default is NULL.}
  \item{y1_2}{the stage one y-coordinate for location for each sample two site.
    The default is NULL.}
  \item{popsize_1}{the known size of the sample one resource - the total number
    of sampling units of a finite resource or the measure of an extensive
    resource, which is required for calculation of finite and continuous
    population correction factors for a single-stage sample.  For a stratified
    sample, this variable also is used to calculate strata weights.  For a
    stratified sample, this variable must be a vector containing a value for
    each stratum and must have the names attribute set to identify the stratum
    codes.  The default is NULL.}
  \item{popsize_2}{the known size of the sample two resource - the total number
    of sampling units of a finite resource or the measure of an extensive
    resource, which is required for calculation of finite and continuous
    population correction factors for a single-stage sample.  For a stratified
    sample, this variable also is used to calculate strata weights.  For a
    stratified sample this variable must be a vector containing a value for each
    stratum and must have the names attribute set to identify the stratum codes.
    The default is NULL.}
  \item{popcorrect_1}{a logical value that indicates whether finite or
    continuous population correction factors should be employed during variance estimation for sample one, where TRUE = use the correction factor and FALSE
    = do not use the correction factor.  The default is FALSE.  To employ the
    correction factor for a single-stage sample, values must be supplied for
    arguments pcfsize_1 and support_1.  To employ the correction factor for a
    two-stage sample, values must be supplied for arguments N.cluster_1,
    stage1size_1, and support_1.}
  \item{pcfsize_1}{size of the sample one resource, which is required for
    calculation of finite and continuous population correction factors for a
    single-stage sample.  For a stratified sample this argument must be a vector
    containing a value for each stratum and must have the names attribute set to
    identify the stratum codes.  The default is NULL.}
  \item{N.cluster_1}{the number of stage one sampling units in the sample one
    resource, which is required for calculation of finite and continuous
    population correction factors for a two-stage sample.  For a stratified
    sample this variable must be a vector containing a value for each stratum
    and must have the names attribute set to identify the stratum codes.  The
    default is NULL.}
  \item{stage1size_1}{size of the stage one sampling units of a two-stage sample
    for sample one, which is required for calculation of finite and continuous
   population correction factors for a two-stage sample and must have the names
   attribute set to identify the stage one sampling unit codes.  For a
   stratified sample, the names attribute must be set to identify both stratum
   codes and stage one sampling unit codes using a convention where the two
   codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".  The
   default is NULL.}
  \item{support_1}{the support value for each sample one site - the value one
    (1) for a site from a finite resource or the measure of the sampling unit
    associated with a site from an extensive resource, which is required for
    calculation of finite and continuous population correction factors.  The
    default is NULL.}
  \item{popcorrect_2}{a logical value that indicates whether finite or
    continuous population correction factors should be employed during variance estimation for sample two, where TRUE = use the correction factor and FALSE
    = do not use the correction factor.  The default is FALSE.  To employ the
    correction factor for a single-stage sample, values must be supplied for
    arguments pcfsize_2 and support_2.  To employ the correction factor for a
    two-stage sample, values must be supplied for arguments N.cluster_2,
    stage1size_2, and support_2.}
   \item{pcfsize_2}{size of the sample two resource, which is required for
    calculation of finite and continuous population correction factors for a
    single-stage sample.  For a stratified sample this argument must be a vector
    containing a value for each stratum and must have the names attribute set to
    identify the stratum codes.  The default is NULL.}
  \item{N.cluster_2}{the number of stage two sampling units in the sample one
    resource, which is required for calculation of finite and continuous
    population correction factors for a two-stage sample.  For a stratified
    sample this variable must be a vector containing a value for each stratum
    and must have the names attribute set to identify the stratum codes.  The
    default is NULL.}
  \item{stage1size_2}{size of the stage one sampling units of a two-stage sample
    for sample two, which is required for calculation of finite and continuous
   population correction factors for a two-stage sample and must have the names
   attribute set to identify the stage one sampling unit codes.  For a
   stratified sample, the names attribute must be set to identify both stratum
   codes and stage one sampling unit codes using a convention where the two
   codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".  The
   default is NULL.}
  \item{support_2}{the support value for each sample two site - the value one
    (1) for a site from a finite resource or the measure of the sampling unit
    associated with a site from an extensive resource, which is required for
    calculation of finite and continuous population correction factors.  The
    default is NULL.}
  \item{sizeweight_1}{a logical value that indicates whether size-weights should 
    be used in the analysis for sample one, where TRUE = use the size-weights
    and FALSE = do not use the size-weights.  The default is FALSE.}
  \item{swgt_1}{the size-weight for each sample one site, which is the stage two
    size-weight for a two-stage sample.  The default is NULL.}
  \item{swgt1_1}{the stage one size-weight for each sample one site.  The
    default is NULL.}
  \item{sizeweight_2}{a logical value that indicates whether size-weights should 
    be used in the analysis for sample two, where TRUE = use the size-weights
    and FALSE = do not use the size-weights.  The default is FALSE.}
  \item{swgt_2}{the size-weight for each sample two site, which is the stage two
    size-weight for a two-stage sample.  The default is NULL.}
  \item{swgt1_2}{the stage one size-weight for each sample two site.  The
    default is NULL.}
  \item{vartype_1}{the choice of variance estimator for sample one, where
    "Local" = local mean estimator and "SRS" = SRS estimator.  The default is
    "Local".}
  \item{vartype_2}{the choice of variance estimator for sample two, where
    "Local" = local mean estimator and "SRS" = SRS estimator.  The default is
    "Local".}
  \item{check.ind}{a logical value that indicates whether compatability checking
    of the input values is conducted, where TRUE = conduct compatibility
    checking and FALSE = do not conduct compatibility checking.  The default is
    TRUE.}
  \item{warn.ind}{a logical value that indicates whether warning messages were
    generated, where TRUE = warning messages were generated and FALSE = warning
    messages were not generated.  The default is NULL.}
  \item{warn.df}{a data frame for storing warning messages.  The default is
    NULL.}
  \item{warn.vec}{a vector that contains names of the population type, the
    subpopulation, and an indicator.  The default is NULL.}
}
\details{
  The inferential procedures divide the CDFs into a discrete set of intervals
  (classes) and then utilize procedures that have been developed for analysis of
  categorical data from probability surveys.  The function calculates the Wald,
  Rao-Scott first order corrected (mean eigenvalue corrected), and Rao-Scott
  second order corrected (Satterthwaite corrected) test statistics.  Both
  standard versions of the three statistics, which are distributed as
  Chi-squared random variables, and alternate version of the statistics, which
  are distributed as F random variables, are available.  The user supplies the
  set of upper bounds that define the intervals (classes) into which the CDFs
  are divided (binned). The minimum number of classes is two.  The
  Horvitz-Thompson ratio estimator, i.e., the ratio of two Horvitz-Thompson
  estimators, is used to calculate estimates of the class proportions for the
  CDFs.  Variance estimates for the test statistics are calculated using either
  the local mean variance estimator or the simple random sampling (SRS) variance
  estimator.  The choice of variance estimator is subject to user control.  The
  SRS variance estimator uses the independent random sample approximation to
  calculate joint inclusion probabilities.  The function can accommodate a
  stratified sample.  For a stratified sample, separate class proportion
  estimates and associated covariance estimates are calculated for each stratum,
  which are used to produce estimates for all strata combined.  Strata that
  contain a single value are removed.  For a stratified sample, when either the
  size of the resource or the sum of the size-weights of the resource is
  provided for each stratum, those values are used as stratum weights for
  calculating the estimates for all strata combined.  For a stratified sample
  when neither the size of the resource nor the sum of the size-weights of the
  resource is provided for each stratum, estimated values are used as stratum
  weights for calculating the estimates for all strata combined.   The function
  can accommodate single-stage and two-stage samples for both stratified and
  unstratified sampling designs.  Finite population and continuous population
  correction factors can be utilized in variance estimation.  The function
  checks for compatability of input values and removes missing values.
}
\value{
  Value is a data frame containing the test statistic, degrees of 
  freedom (two values labeled Degrees of Freedom\_1 and Degrees of  Freedom\_2),
  and p value for the Wald, mean eigenvalue, and Satterthwaite test procedures,
  which includes both Chi-squared distribution and F distribution versions of 
  the procedures.  For the Chi-squared versions of  the test procedures, Degrees
  of Freedom\_1 contains the relevant value  and Degrees of Freedom\_2 is set to 
  missing (NA).  For the F-based  versions of the test procedures Degrees of 
  Freedom\_1 contains the  numerator degrees of freedom and Degrees of 
  Freedom\_2 contains the  denominator degrees of freedom.
}
\references{
  Kincaid, T.M. (2000). Testing for differences between cumulative distribution
  functions from complex environmental sampling surveys.  In \emph{2000
  Proceeding of the Section on Statistics and the Environment}, American
  Statistical Association, Alexandria, VA.
}
\author{Tom Kincaid \email{Kincaid.Tom@epa.gov}}
\examples{
n <- 100
resp <- rnorm(n, 10, 1)
wgt <- runif(n, 10, 100)
sample1 <- list(z=resp, wgt=wgt)
sample2 <- list(z=resp+0.5, wgt=wgt)
bounds <- sort(c(sample1$z, sample2$z))[floor(seq((2*n)/3, (2*n),
  length=3))]
cdf.test(bounds=bounds, z_1=sample1$z, wgt_1=sample1$wgt, z_2=sample2$z,
   wgt_2=sample2$wgt, vartype_1="SRS", vartype_2="SRS")

xcoord <- runif(n)
ycoord <- runif(n)
sample1 <- list(z=resp, wgt=wgt, x=xcoord, y=ycoord)
sample2 <- list(z=1.05*resp, wgt=wgt, x=xcoord, y=ycoord)
cdf.test(bounds=bounds, z_1=sample1$z, wgt_1=sample1$wgt, x_1=sample1$x,
  y_1=sample1$y, z_2=sample2$z, wgt_2=sample2$wgt, x_2=sample2$x,
  y_2=sample2$y)
}
\keyword{survey}
\keyword{distribution}
