\name{cont.cdftest}
\alias{cont.cdftest}
\title{Cumulative Distribution Function Inference for Probability Survey Data}
\description{
  This function organizes input and output for conducting inference regarding
  cumulative distribution functions (CDFs) generated by a probability survey.
  Input can be either an object of class spsurvey.analysis (see the documentation
  for function spsurvey.analysis) or through use of the other arguments to this
  function.
}
\usage{
cont.cdftest(sites=NULL, subpop=NULL, design=NULL, data.cont=NULL, popsize=NULL,
  popcorrect=FALSE, pcfsize=NULL, N.cluster=NULL, stage1size=NULL,
  sizeweight=FALSE, vartype="Local", testname="Wald_F", nclass=3,
  spsurvey.obj=NULL)
}
\arguments{
  \item{sites}{a data frame consisting of two variables: the first variable is 
    site IDs, and the second variable is a logical vector indicating which
    sites to use in the analysis.  If spsurvey.obj is not provided, then
    this argument is required.  The default is NULL.}
  \item{subpop}{a data frame describing sets of populations and subpopulations 
    for which estimates will be calculated.  The first variable is site  
    IDs.  Each subsequent variable identifies a Type of population, where
    the variable name is used to identify Type.  A Type variable
    identifies each site with one of the subpopulations of that Type.  If
    spsurvey.obj is not provided, then this argument is required.  The
    default is NULL.}
  \item{design}{a data frame consisting of design variables.  If spsurvey.obj is
    not provided, then this argument is required.  The default is NULL.
    Variables should be named as follows:\cr
       siteID = site IDs\cr
       wgt = final adjusted weights, which are either the weights for a
         single-stage sample or the stage two weights for a two-stage sample\cr
       xcoord = x-coordinates for location, which are either the x-coordinates
         for a single-stage sample or the stage two x-coordinates for a
         two-stage sample\cr
       ycoord = y-coordinates for location, which are either the y-coordinates
         for a single-stage sample or the stage two y-coordinates for a
         two-stage sample\cr
       stratum = the stratum codes\cr
       cluster = the stage one sampling unit (primary sampling unit or cluster)
         codes\cr
       wgt1 = final adjusted stage one weights\cr
       xcoord1 = the stage one x-coordinates for location\cr
       ycoord1 = the stage one y-coordinates for location\cr
       support = support values - the value one (1) for a site from a 
         finite resource or the measure of the sampling unit associated 
         with a site from an extensive resource, which is required for 
         calculation of finite and continuous population correction 
         factors\cr
       swgt = size-weights, which is the stage two size-weight for a two-
         stage sample\cr
       swgt1 = stage one size-weights}
  \item{data.cont}{a data frame of continuous response variables.  The first 
    variable is site IDs.  Subsequent variables are response variables.
    Missing data (NA) is allowed.  If spsurvey.obj is not provided, then
    this argument is required.  The default is NULL.}
  \item{popsize}{known size of the resource, which is used to perform ratio
    adjustment to estimators expressed using measurement units for the
    resource.  For a finite resource, this argument is either the total number
    of sampling units or the known sum of size-weights.  For an extensive
    resource, this argument is the measure of the resource, i.e., either known
    total length for a linear resource or known total area for an areal
    resource.  The argument must be in the form of a list containing an
    element for each population Type in the subpop data frame, where NULL is a
    valid choice for a population Type.  The list must be named using the
    column names for the population Types in subpop. If a population Type
    doesn't contain subpopulations, then each element of the list is either a
    single value for an unstratified sample or a vector containing a value for
    each stratum for a stratified sample, where elements of the vector are
    named using the stratum codes.  If a population Type contains
    subpopulations, then each element of the list is a list containing an
    element for each subpopulation, where the list is named using the
    subpopulation names.  The element for each subpopulation will be either a
    single value for an unstratified sample or a named vector of values for a
    stratified sample.  The default is NULL.\cr\cr
    Example popsize for a stratified sample:\cr
      popsize = list("Pop 1"=c("Stratum 1"=750,\cr
                               "Stratum 2"=500,\cr
                               "Stratum 3"=250),\cr
                     "Pop 2"=list("SubPop 1"=c("Stratum 1"=350,\cr
                                               "Stratum 2"=250,\cr
                                               "Stratum 3"=150),\cr
                                  "SubPop 2"=c("Stratum 1"=250,\cr
                                               "Stratum 2"=150,\cr
                                               "Stratum 3"=100),\cr
                                  "SubPop 3"=c("Stratum 1"=150,\cr
                                               "Stratum 2"=150,\cr
                                               "Stratum 3"=75)),\cr
                     "Pop 3"=NULL)\cr\cr
    Example popsize for an unstratified sample:\cr
      popsize = list("Pop 1"=1500,\cr
                     "Pop 2"=list("SubPop 1"=750,\cr
                                  "SubPop 2"=500,\cr
                                  "SubPop 3"=375),\cr
                     "Pop 3"=NULL)\cr}
  \item{popcorrect}{a logical value that indicates whether finite or continuous 
    population correction factors should be employed during variance 
    estimation, where TRUE = use the correction factors and FALSE = do not 
    use the correction factors.  The default is FALSE.}
  \item{pcfsize}{size of the resource, which is required for calculation of
    finite and continuous population correction factors for a single-stage
    sample.  For a stratified sample this argument must be a vector containing a
    value for each stratum and must have the names attribute set to identify the
    stratum codes.  The default is NULL.}
  \item{N.cluster}{the number of stage one sampling units in the resource, which 
    is required for calculation of finite and continuous population 
    correction factors for a two-stage sample.  For a stratified sample 
    this variable must be a vector containing a value for each stratum and
    must have the names attribute set to identify the stratum codes.  The
    default is NULL.}
  \item{stage1size}{size of the stage one sampling units of a two-stage sample,
    which is required for calculation of finite and continuous population
    correction factors for a two-stage sample and must have the names
    attribute set to identify the stage one sampling unit codes.  For a
    stratified sample, the names attribute must be set to identify both
    stratum codes and stage one sampling unit codes using a convention where
    the two codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".
    The default is NULL.}
  \item{sizeweight}{a logical value that indicates whether size-weights should 
    be used in the analysis, where TRUE = use the size-weights and FALSE = 
    do not use the size-weights.  The default is FALSE.}
  \item{vartype}{the choice of variance estimator, where "Local" = local mean
    estimator and "SRS" = SRS estimator.  The default is "Local".}
  \item{testname}{name of the test statistic to be reported in the output data
    frame.  Choices for the name are: "Wald", "Wald\_F", "Mean\_Eigenvalue",
    "Mean\_Eigenvalue\_F", "Satterthwaite", and "Satterthwaite\_F".  The default
    is "Wald\_F".}
  \item{nclass}{number of classes into which the CDFs will be divided (binned),
    which must equal at least three.  The default is 3.}
  \item{spsurvey.obj}{A list of class spsurvey.analysis that was produced by the
    function spsurvey.analysis.  Depending on input to that function, some
    elements of the list may be NULL.  The default is NULL.}
}
\details{
  For every response variable and every population Type, differences between
  CDFs are tested for every pair of subpopulations within a Type.  The
  inferential procedures divide the CDFs into a discrete set of intervals
  (classes) and then utilize procedures that have been developed for analysis of
  categorical data from probability surveys.  Choices for inference are the
  Wald, Rao-Scott first order corrected (mean eigenvalue corrected), and
  Rao-Scott second order corrected (Satterthwaite corrected) test statistics.
  Both standard versions of the three statistics, which are distributed as
  Chi-squared random variables, and alternate version of the statistics, which
  are distributed as F random variables, are available.  The default test
  statistic is the F distribution version of the Wald statistic.
}
\value{
  A data frame of CDF test results for all pairs of subpopulations within each
  population Type for every response variable.  The data frame includes the
  test statistic specified by argument testname plus its degrees of freedom
  and p-value.
}
\references{
  Kincaid, T.M. (2000). Testing for differences between cumulative distribution
  functions from complex environmental sampling surveys.  In \emph{2000
  Proceeding of the Section on Statistics and the Environment}, American
  Statistical Association, Alexandria, VA.
}
\author{Tom Kincaid \email{Kincaid.Tom@epa.gov}}
\seealso{
\code{\link{cdf.test}} 
}
\examples{
n <- 200
mysiteID <- paste("Site", 1:n, sep="")
mysites <- data.frame(siteID=mysiteID, Active=rep(TRUE, n))
mysubpop <- data.frame(siteID=mysiteID,  Resource_Class=sample(c("Agr",
  "Forest", "Urban"), n, replace=TRUE))
mydesign <- data.frame(siteID=mysiteID, wgt=runif(n, 10, 100),
  xcoord=runif(n), ycoord=runif(n), stratum=rep(c("Stratum1",
  "Stratum2"), n/2))
mypopsize <- list(Resource_Class=list(Agr=c(Stratum1=2500, Stratum2=1500),
  Forest=c(Stratum1=1000, Stratum2=500), Urban=c(Stratum1=600, Stratum2=450)))
ContVar <- numeric(n)
tst <- mysubpop$Resource_Class == "Agr"
ContVar[tst] <- rnorm(sum(tst), 10, 1)
tst <- mysubpop$Resource_Class == "Forest"
ContVar[tst] <- rnorm(sum(tst), 10.1, 1)
tst <- mysubpop$Resource_Class == "Urban"
ContVar[tst] <- rnorm(sum(tst), 10.5, 1)
mydata.cont <- data.frame(siteID=mysiteID, ContVar=ContVar)
cont.cdftest(sites=mysites, subpop=mysubpop, design=mydesign,
  data.cont=mydata.cont, popsize=mypopsize, testname="Mean_Eigenvalue")
}
\keyword{survey}
\keyword{distribution}
