% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoR2.R, R/pseudoR2_glm.R
\name{pseudoR2}
\alias{pseudoR2}
\alias{pseudoR2.splm}
\alias{pseudoR2.spautor}
\alias{pseudoR2.spglm}
\alias{pseudoR2.spgautor}
\title{Compute a pseudo r-squared}
\usage{
pseudoR2(object, ...)

\method{pseudoR2}{splm}(object, adjust = FALSE, ...)

\method{pseudoR2}{spautor}(object, adjust = FALSE, ...)

\method{pseudoR2}{spglm}(object, adjust = FALSE, ...)

\method{pseudoR2}{spgautor}(object, adjust = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{adjust}{A logical indicating whether the pseudo r-squared
should be adjusted to account for the number of explanatory variables. The
default is \code{FALSE}.}
}
\value{
The pseudo r-squared as a numeric vector.
}
\description{
Compute a pseudo r-squared for a fitted model object.
}
\details{
Several pseudo r-squared statistics exist for in the literature.
We define this pseudo r-squared as one minus the ratio of the deviance of a full model
relative to the deviance of a null (intercept only) model. This pseudo r-squared
can be viewed as a generalization of the classical r-squared definition
seen as one minus the ratio of error sums of squares from the full model relative
to the error sums of squares from the null model. If adjusted, the adjustment
is analogous to the the classical r-squared adjustment.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
pseudoR2(spmod)
}
