% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R, R/print_glm.R
\name{print.spmodel}
\alias{print.spmodel}
\alias{print.splm}
\alias{print.spautor}
\alias{print.summary.splm}
\alias{print.summary.spautor}
\alias{print.anova.splm}
\alias{print.anova.spautor}
\alias{print.spglm}
\alias{print.spgautor}
\alias{print.summary.spglm}
\alias{print.summary.spgautor}
\alias{print.anova.spglm}
\alias{print.anova.spgautor}
\title{Print values}
\usage{
\method{print}{splm}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{spautor}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.splm}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{summary.spautor}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{anova.splm}(
  x,
  digits = max(getOption("digits") - 2L, 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{anova.spautor}(
  x,
  digits = max(getOption("digits") - 2L, 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{spglm}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{spgautor}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.spglm}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{summary.spgautor}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{anova.spglm}(
  x,
  digits = max(getOption("digits") - 2L, 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{anova.spgautor}(
  x,
  digits = max(getOption("digits") - 2L, 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}} or output from
\code{summary(x)} or or \code{anova(x)}.}

\item{digits}{The number of significant digits to use when printing.}

\item{...}{Other arguments passed to or from other methods.}

\item{signif.stars}{Logical. If \code{TRUE}, significance stars are printed for each coefficient}
}
\value{
Printed fitted model objects and summaries with formatting.
}
\description{
Print fitted model objects and summaries.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
print(spmod)
print(summary(spmod))
print(anova(spmod))
}
