% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_sp-network-multi.R
\docType{class}
\name{sp_multi_network-class}
\alias{sp_multi_network-class}
\alias{id,sp_multi_network-method}
\alias{dat,sp_multi_network-method}
\alias{neighborhood,sp_multi_network-method}
\alias{pull_member,sp_multi_network-method}
\title{Class sp_multi_network}
\usage{
\S4method{id}{sp_multi_network}(object)

\S4method{dat}{sp_multi_network}(object, .id)

\S4method{neighborhood}{sp_multi_network}(object, .id = 1)

\S4method{pull_member}{sp_multi_network}(object, .id)
}
\arguments{
\item{object}{sp_multi_network-class}

\item{.id}{A character indicating the id of a \code{\link[=sp_network_nodes-class]{sp_network_nodes-class()}} or a
\code{\link[=sp_network_pair-class]{sp_network_pair-class()}} inside the \code{\link[=sp_multi_network-class]{sp_multi_network-class()}}.}
}
\description{
A S4 class that gathers information on one or multiple networks
\code{\link[=sp_network_nodes]{sp_network_nodes()}} and origin-destination pairs \code{\link[=sp_network_pair]{sp_network_pair()}}.
The class is constructed with the \code{\link[=sp_multi_network]{sp_multi_network()}} function.
}
\section{Slots}{

\describe{
\item{\code{networks}}{A list of \code{\link[=sp_network_nodes-class]{sp_network_nodes-class()}} objects}

\item{\code{network_pairs}}{A list of \code{\link[=sp_network_pair-class]{sp_network_pair-class()}} objects}
}}

\examples{
## access the id of a networks or network_pairs inside a multi network

id(multi_net_usa_ge)$networks
id(multi_net_usa_ge)$network_pairs

## access the data of a network or a network_pair inside a multi_network

dat(multi_net_usa_ge, "ge")    # extract data of nodes
dat(multi_net_usa_ge, "ge_ge") # extract data of pairs

## access sp_network_nodes or sp_network_pair inside a sp_multi_network

pull_member(multi_net_usa_ge,"ge")
pull_member(multi_net_usa_ge,"usa")
pull_member(multi_net_usa_ge,"ge_ge")

}
\seealso{
Other spflow network classes: 
\code{\link{sp_network_nodes-class}},
\code{\link{sp_network_pair-class}},
\code{\link{spflow_network_classes}}
}
\concept{spflow network classes}
