% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs_batch_fit.R
\name{svs_1h_brain_analysis}
\alias{svs_1h_brain_analysis}
\title{Standard SVS 1H brain analysis pipeline.}
\usage{
svs_1h_brain_analysis(
  metab,
  basis = NULL,
  w_ref = NULL,
  mri_seg = NULL,
  mri = NULL,
  output_dir = NULL,
  extra = NULL,
  decimate = NULL,
  rats_corr = TRUE,
  ecc = FALSE,
  comb_dyns = TRUE,
  hsvd_filt = FALSE,
  scale_amps = TRUE,
  te = NULL,
  tr = NULL,
  preproc_only = FALSE,
  method = "ABFIT",
  opts = NULL
)
}
\arguments{
\item{metab}{filepath or mrs_data object containing MRS metabolite data.}

\item{basis}{basis set object to use for analysis.}

\item{w_ref}{filepath or mrs_data object containing MRS water reference data.}

\item{mri_seg}{filepath or nifti object containing segmented MRI data.}

\item{mri}{filepath or nifti object containing anatomical MRI data.}

\item{output_dir}{directory path to output fitting results.}

\item{extra}{data.frame with one row containing additional information to be
attached to the fit results table.}

\item{decimate}{option to decimate the input data by a factor of two. The
default value of NULL does not perform decimation unless the spectral width
is greater than 20 PPM.}

\item{rats_corr}{option to perform rats correction, defaults to TRUE.}

\item{ecc}{option to perform water reference based eddy current correction,
defaults to FALSE.}

\item{comb_dyns}{option to combine dynamic scans, defaults to TRUE.}

\item{hsvd_filt}{option to apply hsvd water removal, defaults to FALSE.}

\item{scale_amps}{option to scale metabolite amplitude estimates, defaults to
TRUE.}

\item{te}{metabolite mrs data echo time in seconds.}

\item{tr}{metabolite mrs data repetition time in seconds.}

\item{preproc_only}{only perform the preprocessing steps and omit fitting.
The preprocessed metabolite data will be returned in this case.}

\item{method}{analysis method to use, see fit_mrs help.}

\item{opts}{options to pass to the analysis method.}
}
\value{
a fit_result or mrs_data object depending on the preproc_only option.
}
\description{
Standard SVS 1H brain analysis pipeline.
}
