\name{over-methods}
\docType{methods}
\alias{over}
\alias{\%over\%}
\alias{over-methods}
\alias{over,SpatialPoints,SpatialPoints-method}
\alias{over,SpatialPoints,SpatialPointsDataFrame-method}
\alias{over,SpatialPoints,SpatialPolygons-method}
\alias{over,SpatialPoints,SpatialPolygonsDataFrame-method}
\alias{over,SpatialGridDataFrame,SpatialPolygonsDataFrame-method}
\alias{over,SpatialPolygons,SpatialPoints-method}
\alias{over,SpatialPolygons,SpatialPointsDataFrame-method}
\alias{over,SpatialGridDataFrame,SpatialPoints-method}
\alias{over,SpatialGrid,SpatialPoints-method}
\alias{over,SpatialPixelsDataFrame,SpatialPoints-method}
\alias{over,SpatialPixels,SpatialPoints-method}
\alias{over,SpatialPoints,SpatialGrid-method}
\alias{over,SpatialPoints,SpatialGridDataFrame-method}
\alias{over,SpatialPoints,SpatialPixels-method}
\alias{over,SpatialPoints,SpatialPixelsDataFrame-method}
\alias{over,SpatialPolygons,SpatialGridDataFrame-method}
\alias{aggregate.Spatial}
\title{ consistent spatial overlay for points, grids and polygons }
\description{ consistent spatial overlay for points, grids and polygons:
retrieves the indexes or attributes from one geometry at the spatial
locations of another }
\usage{
over(x, y, returnList = FALSE, fn = NULL, ...)
x \%over\% y
\method{aggregate}{Spatial}(x, by, FUN = mean, \dots)
}
\arguments{
\item{x}{geometry (locations) of the queries}
\item{y}{layer from which the geometries or attributes are queried}
\item{returnList}{ logical; see value }
\item{fn}{(optional) a function; see value }
\item{by}{ geometry over which attributes in \code{x} are aggregated }
\item{FUN}{aggregation function }
\item{...}{arguments passed on to function fn or FUN}
}
\value{ 
an object of length \code{length(x)}, or a data.frame with
number of rows equal to \code{length(x)}. If \code{returnList}
is FALSE, a vector with the (first) index of \code{y} for each
geometry (point, grid cell centre, polygon or lines) in \code{x}.
if \code{returnList} is TRUE, a list of length \code{length(x)}, with
list element \code{i} the vector of all indices of the geometries
in \code{y} that correspond to the $i$-th geometry in \code{x}.

Function aggregate.Spatial aggregates the attribute values
of \code{x} over the geometry of \code{by}, using aggregation
function FUN.
}

\section{Methods}{
\describe{
\item{x = "SpatialPoints", y = "SpatialPolygons"}{ returns a numeric
vector of length equal to the number of points; the number is the
index (number) of the polygon of \code{y} in which a point falls;
NA denotes the point does not fall in a polygon; if a point falls
in multiple polygons, the last polygon is recorded.  }
\item{x = "SpatialPointsDataFrame", y = "SpatialPolygons"}{ equal
to the previous method, except that an argument \code{fn=xxx} is
allowed, e.g. \code{fn = mean} which will then report a data.frame
with the mean values of the \code{x} points falling in each polygon
(set) of \code{y} }
\item{x = "SpatialPoints", y = "SpatialPolygonsDataFrame"}{ returns
a data.frame of the second argument with row entries corresponding
to the first argument }
\item{x = "SpatialPolygons", y = "SpatialPoints"}{ returns
the polygon index of points in \code{y}; if \code{x} is
a \code{SpatialPolygonsDataFrame}, a data.frame with rows from
\code{x} corresponding to points in \code{y} is returned.}
\item{x = "SpatialGridDataFrame", y = "SpatialPoints"}{ returns
object of class SpatialPointsDataFrame with grid attribute values
x at spatial point locations y; NA for NA grid cells or points
outside grid, and NA values on NA grid cells. }
\item{x = "SpatialGrid", y = "SpatialPoints"}{ returns grid values
x at spatial point locations y; NA for NA grid cells or points
outside the grid }
\item{x = "SpatialPixelsDataFrame", y = "SpatialPoints"}{ returns
grid values x at spatial point locations y; NA for NA grid cells
or points outside the grid }
\item{x = "SpatialPixels", y = "SpatialPoints"}{ returns grid
values x at spatial point locations y; NA for NA grid cells or
points outside the grid }
\item{x = "SpatialPoints", y = "SpatialGrid"}{ xx }
\item{x = "SpatialPoints", y = "SpatialGridDataFrame"}{ xx }
\item{x = "SpatialPoints", y = "SpatialPixels"}{ xx }
\item{x = "SpatialPoints", y = "SpatialPixelsDataFrame"}{ xx }
\item{x = "SpatialPolygons", y = "SpatialGridDataFrame"}{ xx }
}
}
\author{Edzer Pebesma, \email{edzer.pebesma@uni-muenster.de}}

\note{points on a polygon boundary and points corresponding to a
polygon vertex are considered to be inside the polygon.

These methods assume that pixels and grid cells are never
overlapping.  

Methods that involve \code{SpatialLines} objects, or pairs of
\code{SpatialPolygons} require, and are implemented in, package
rgeos.}

\seealso{\link{overlay}, \link{point.in.polygon}}
\examples{
r1 = cbind(c(180114, 180553, 181127, 181477, 181294, 181007, 180409, 
180162, 180114), c(332349, 332057, 332342, 333250, 333558, 333676, 
332618, 332413, 332349))
r2 = cbind(c(180042, 180545, 180553, 180314, 179955, 179142, 179437, 
179524, 179979, 180042), c(332373, 332026, 331426, 330889, 330683, 
331133, 331623, 332152, 332357, 332373))
r3 = cbind(c(179110, 179907, 180433, 180712, 180752, 180329, 179875, 
179668, 179572, 179269, 178879, 178600, 178544, 179046, 179110),
c(331086, 330620, 330494, 330265, 330075, 330233, 330336, 330004, 
329783, 329665, 329720, 329933, 330478, 331062, 331086))

sr1=Polygons(list(Polygon(r1)),"r1")
sr2=Polygons(list(Polygon(r2)),"r2")
sr3=Polygons(list(Polygon(r3)),"r3")
sr=SpatialPolygons(list(sr1,sr2,sr3))
srdf=SpatialPolygonsDataFrame(sr, data.frame(cbind(1:3,5:3), row.names=c("r1","r2","r3")))

data(meuse)
coordinates(meuse) = ~x+y
data(meuse.grid)
coordinates(meuse.grid) = ~x+y
gridded(meuse.grid) = TRUE

plot(meuse)
polygon(r1)
polygon(r2)
polygon(r3)

over(sr, geometry(meuse))
over(sr, meuse)
over(sr, geometry(meuse), returnList = TRUE)
over(sr, meuse, returnList = TRUE)

over(meuse, sr)
over(meuse, srdf)

# same thing, with grid:
over(sr, meuse.grid)
over(sr, meuse.grid, fn = mean)
over(sr, meuse.grid, returnList = TRUE)

over(meuse.grid, sr)
over(meuse.grid, srdf, fn = mean)
over(as(meuse.grid, "SpatialPoints"), sr)
over(as(meuse.grid, "SpatialPoints"), srdf)
}
\keyword{methods}
