% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{addPitchCands}
\alias{addPitchCands}
\title{Plot pitch candidates}
\usage{
addPitchCands(pitchCands, pitchCert, pitchSource, pitch,
  candPlot = list(), pitchPlot = list(col = rgb(0, 0, 1, 0.75), lwd =
  3), addToExistingPlot = TRUE, showLegend = TRUE, ...)
}
\arguments{
\item{pitchCands, pitchCert, pitchSource}{matrices of pitch candidates, their
certainty, and pitch tracking method used as generated internally by
analyze(); columns = STFT frames, rows = candidates}

\item{pitch}{best guess at pitch contour; length = ncol(pitchCands)}

\item{candPlot, pitchPlot}{lists of graphical settings for plotting candidates
and pitch contour, respectively}

\item{addToExistingPlot}{if TRUE, assumes that a spectrogram is already
plotted; if FALSE, sets up a new plot}

\item{showLegend}{if TRUE, shows a legend}

\item{...}{other graphical parameters used for creating a new plot if
addToExistingPlot = FALSE}
}
\description{
Internal soundgen function.
}
\details{
Plots pitch candidates or adds them to a spectrogram.
}
\examples{
\dontrun{
s = soundgen()
a = analyze(s, 16000, windowLength = 25, step = 25,
            summary = 'extended', plot = FALSE)
spectrogram(s, 16000, windowLength = 25, step = 5)
addPitchCands(pitchCands = a$pitchCands,
              pitchCert = a$pitchCert,
              pitchSource = a$pitchSource,
              pitch = a$result$pitch)
}
}
