% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/solar.lib.R
\name{solar}
\alias{solar}
\title{Call SOLAR program from R}
\usage{
solar(cmd, dir, result = TRUE, ignore.stdout = TRUE,
  ignore.stderr = FALSE, ...)
}
\arguments{
\item{cmd}{A vector of characters, that contains the commands to be passed to SOLAR.}

\item{dir}{A character, path to the directory, where SOLAR-related files (phenotypes, pedigree, markers)
were previously created.}

\item{result}{A logical, \code{intern} argument to be passed to \code{system} function.
The default value is TRUE.}

\item{ignore.stdout}{A logical, \code{ignore.stdout} argument to be passed to \code{system} function.
The default value is FALSE.}

\item{ignore.stderr}{A logical, \code{ignore.stderr} argument to be passed to \code{system} function.
The default value is TRUE.}

\item{...}{additional arguments (which are not used).}
}
\description{
The function calls SOLAR via \code{system} function,
that invokes the OS command (which is \code{solar}) specified by the command argument.
SOLAR is required to be installed in the OS.
}
\details{
This is the core function in the interface between R and SOLAR.
}

