% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.lib.R
\name{plotManh}
\alias{plotManh}
\alias{plotQQ}
\title{Plot the association results}
\usage{
plotManh(A, alpha = 0.05, main, ...)

plotQQ(A, df = 1, main, ...)
}
\arguments{
\item{A}{An object of class \code{solarAssoc}.}

\item{alpha}{A numeric value from 0 to 1, the p-value cut-off
for Bonferroni multiple-test correction.
The default value is 0.05.}

\item{main}{A character string, \code{main} argument (title) to a plot function.
If the argument is missing, the title contains information about the model formula and the number of SNPs used for plotting.}

\item{...}{additional argument to a plot function.}

\item{df}{An integer value, the degree of freedom.
 The default value is 1.}
}
\description{
Two Manhattan and quantile-quantile (QQ) plots
are standard to explore the results from association studies.
}
\details{
\code{plotManh} function produces the Manhattan plot based on \code{qqman} package.
The two red and blue lines, default in the original \code{manhattan} function
of \code{qqman} package, are preserved.
An additional black dashed line is added, that depicts the significance level
according to Bonferroni multiple-test correction with \code{alpha} argument.

\code{plotQQ} function produces the QQ plot based on the same \code{qqman} package.
}
\examples{
\dontrun{
data(dat50)

assoc <- solarAssoc(trait ~ 1, phenodata,
 snpdata = genodata, snpmap = snpdata, kinship = kin)

plotManh(assoc) # equivalent to plot(assoc)

plotQQ(assoc) # equivalent to plot(assoc, "qq")

}
}
\seealso{
\code{\link{solarAssocClass}}
}

