% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchNASISWebReport.R,
%   R/get_cosoilmoist_from_NASISWebReport.R
\name{fetchNASISWebReport}
\alias{fetchNASISWebReport}
\alias{get_project_from_NASISWebReport}
\alias{get_progress_from_NASISWebReport}
\alias{get_project_correlation_from_NASISWebReport}
\alias{get_legend_from_NASISWebReport}
\alias{get_mapunit_from_NASISWebReport}
\alias{get_projectmapunit_from_NASISWebReport}
\alias{get_projectmapunit2_from_NASISWebReport}
\alias{get_component_from_NASISWebReport}
\alias{get_chorizon_from_NASISWebReport}
\alias{get_cosoilmoist_from_NASISWebReport}
\alias{get_sitesoilmoist_from_NASISWebReport}
\alias{get_lmuaoverlap_from_NASISWebReport}
\title{Get component tables from NASIS Web Reports}
\usage{
fetchNASISWebReport(
  projectname,
  rmHzErrors = FALSE,
  fill = FALSE,
  stringsAsFactors = NULL
)

get_component_from_NASISWebReport(projectname, stringsAsFactors = NULL)

get_chorizon_from_NASISWebReport(
  projectname,
  fill = FALSE,
  stringsAsFactors = NULL
)

get_legend_from_NASISWebReport(
  mlraoffice,
  areasymbol,
  droplevels = TRUE,
  stringsAsFactors = NULL
)

get_lmuaoverlap_from_NASISWebReport(
  areasymbol,
  droplevels = TRUE,
  stringsAsFactors = NULL
)

get_mapunit_from_NASISWebReport(
  areasymbol,
  droplevels = TRUE,
  stringsAsFactors = NULL
)

get_projectmapunit_from_NASISWebReport(projectname, stringsAsFactors = NULL)

get_projectmapunit2_from_NASISWebReport(
  mlrassoarea,
  fiscalyear,
  projectname,
  stringsAsFactors = NULL
)

get_project_from_NASISWebReport(mlrassoarea, fiscalyear)

get_progress_from_NASISWebReport(mlrassoarea, fiscalyear, projecttypename)

get_project_correlation_from_NASISWebReport(
  mlrassoarea,
  fiscalyear,
  projectname
)

get_cosoilmoist_from_NASISWebReport(
  projectname,
  impute = TRUE,
  stringsAsFactors = NULL
)

get_sitesoilmoist_from_NASISWebReport(usiteid)
}
\arguments{
\item{projectname}{text string vector of project names to be inserted into a
SQL WHERE clause (default: \code{NA})}

\item{rmHzErrors}{should pedons with horizonation errors be removed from the
results? (default: \code{FALSE})}

\item{fill}{should rows with missing component ids be removed (default: \code{FALSE})}

\item{stringsAsFactors}{deprecated}

\item{mlraoffice}{text string value identifying the MLRA Regional Soil
Survey Office group name inserted into a SQL WHERE clause (default: \code{NA})}

\item{areasymbol}{text string value identifying the area symbol (e.g.
\code{IN001} or \verb{IN\%}) inserted into a SQL WHERE clause (default: \code{NA})
\code{NULL} (default: \code{TRUE})}

\item{droplevels}{logical: indicating whether to drop unused levels in
classifying factors. This is useful when a class has large number of unused
classes, which can waste space in tables and figures.}

\item{mlrassoarea}{text string value identifying the MLRA Soil Survey Office
areasymbol symbol inserted into a SQL WHERE clause (default: \code{NA})}

\item{fiscalyear}{text string value identifying the fiscal year inserted
into a SQL WHERE clause (default: \code{NA})}

\item{projecttypename}{text string value identifying the project type name
inserted into a SQL WHERE clause (default: \code{NA})}

\item{impute}{replace missing (i.e. \code{NULL}) values with \code{"Not_Populated"} for
categorical data, or the "RV" for numeric data or \code{201} cm if the "RV" is also
\code{NULL} (default: \code{TRUE})}

\item{usiteid}{character: User Site IDs}
}
\value{
A data.frame or list with the results.
}
\description{
Get component tables from NASIS Web Reports
}
\author{
Stephen Roecker
}
\keyword{manip}
