% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBiObjBBOBFunction.R
\name{makeBiObjBBOBFunction}
\alias{makeBiObjBBOBFunction}
\title{Generator for the function set of the real-parameter Bi-Objective
Black-Box Optimization Benchmarking (BBOB).}
\usage{
makeBiObjBBOBFunction(dimensions, fid, iid)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Problem dimensions. Integer value between 2 and 40.}

\item{fid}{[\code{integer(1)}]\cr
Function identifier. Integer value between 1 and 55.}

\item{iid}{[\code{integer(1)}]\cr
Instance identifier. Integer value greater than or equal 1.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Generator for the function set of the real-parameter Bi-Objective
Black-Box Optimization Benchmarking (BBOB).
}
\note{
Concatenation of single-objective BBOB functions into
a bi-objective problem.
}
\examples{
# get the fifth instance of the concatenation of the
# 3D versions of sphere and Rosenbrock
fn = makeBiObjBBOBFunction(dimensions = 3L, fid = 4L, iid = 5L)
fn(c(3, -1, 0))
# compare to the output of its single-objective pendants
f1 = makeBBOBFunction(dimensions = 3L, fid = 1L, iid = 2L * 5L + 1L)
f2 = makeBBOBFunction(dimensions = 3L, fid = 8L, iid = 2L * 5L + 2L)
identical(fn(c(3, -1, 0)), c(f1(c(3, -1, 0)), f2(c(3, -1, 0))))
}
\references{
See the \href{http://numbbo.github.io/coco-doc/bbob-biobj/functions/}{COCO website}
for a detailed description of the bi-objective BBOB functions.
An overview of which pair of single-objective BBOB functions creates
which of the 55 bi-objective BBOB functions can be found \href{http://numbbo.github.io/coco-doc/bbob-biobj/functions/#the-bbob-biobj-test-functions-and-their-properties}{here}.
}
