% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gw_cov}
\alias{gw_cov}
\title{Generalized Wendland covariance function for a given distance matrix.}
\usage{
gw_cov(dists, sigsq, phi, kappa, mu)
}
\arguments{
\item{dists}{a numeric matrix representing the distance between spatial
entities.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{\eqn{\phi} is the range of the covariance function.}

\item{kappa}{\eqn{\kappa \in \{0, \ldots, 3 \}}.}

\item{mu}{\eqn{\mu} controls the smoothness of the covariance function}
}
\value{
The GW (isotropic) covariance function associated with the provided
distances (\code{dists}) and the given set of parameters.
}
\description{
Computing the Matern covariance function for a matrix of
distances.
}
\keyword{internal}
