% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_descendants}
\alias{ts_descendants}
\title{Extract all descendants of a given tree-sequence node}
\usage{
ts_descendants(ts, x, verbose = FALSE, complete = TRUE)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{x}{An integer node ID of the ancestral node}

\item{verbose}{Report on the progress of ancestry path generation?}

\item{complete}{Does every individual in the tree sequence need to have
complete metadata recorded? If \code{TRUE}, only individuals/nodes with
complete metadata will be included in the reconstruction of ancestral
relationships. For instance, nodes added during the coalescent recapitation
phase will not be included because they don't have spatial information
associated with them.}
}
\value{
A table of descendant nodes of a given tree-sequence node all the
way down to the leaves of the tree sequence
}
\description{
Extract all descendants of a given tree-sequence node
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model)

# find the complete descendancy information for a given individual
ts_descendants(ts, x = 62, verbose = TRUE)
}
