% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_labelled.R
\name{as_labelled}
\alias{as_labelled}
\title{Convert vector to labelled class}
\usage{
as_labelled(x, add.labels = FALSE, add.class = FALSE)
}
\arguments{
\item{x}{Variable (vector), \code{data.frame} or \code{list} of variables
that should be converted to \code{\link[haven]{labelled}}-class
objects.}

\item{add.labels}{Logical, if \code{TRUE}, non-labelled values will be
labelled with the corresponding value.}

\item{add.class}{Logical, if \code{TRUE}, \code{x} preserves its former
\code{class}-attribute and \code{labelled} is added as additional
attribute. If \code{FALSE} (default), all former \code{class}-attributes
will be removed and the class-attribute of \code{x} will only
be \code{labelled}.}
}
\value{
\code{x}, as \code{labelled}-class object.
}
\description{
Converts a (labelled) vector of any class into a \code{labelled}
               class vector, resp. adds a \code{labelled} class-attribute.
}
\note{
This function is deprecated. Please use \CRANpkg{sjlabelled} for
      labelled data functions now.
}
\examples{
data(efc)
str(efc$e42dep)

x <- as_labelled(efc$e42dep)
str(x)

x <- as_labelled(efc$e42dep, add.class = TRUE)
str(x)

a <- c(1, 2, 4)
x <- as_labelled(a, add.class = TRUE)
str(x)

data(efc)
x <- set_labels(efc$e42dep,
                labels = c(`1` = "independent", `4` = "severe dependency"))
x1 <- as_labelled(x, add.labels = FALSE)
x2 <- as_labelled(x, add.labels = TRUE)

str(x1)
str(x2)

get_values(x1)
get_values(x2)

}
