% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{obtener_fila_mas_casos}
\alias{obtener_fila_mas_casos}
\title{Obtener la fila con mayor número de casos}
\usage{
obtener_fila_mas_casos(data_event, nomb_col = "casos", porcentaje = TRUE)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de la
enfermedad o evento.}

\item{nomb_col}{Un `character` (cadena de caracteres) con el
nombre de la columna que contiene el número de casos en los datos de
la enfermedad o evento.}

\item{porcentaje}{Un `logical` (`TRUE` o `FALSE`) que indica si se
requiere agregar un porcentaje de casos como columna.}
}
\value{
Un `data.frame` que contiene la fila con mayor número de casos.
}
\description{
Función que obtiene la fila con el mayor número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
casos_sex <- agrupar_sex(
  data_event = data_limpia,
  porcentaje = TRUE
)
obtener_fila_mas_casos(
  data_event = casos_sex,
  nomb_col = "casos",
  porcentaje = TRUE
)
}
