% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleMH.R
\name{simpleMH}
\alias{simpleMH}
\title{Simple Metropolis-Hastings MCMC}
\usage{
simpleMH(f, inits, theta.cov, max.iter, coda = FALSE, ...)
}
\arguments{
\item{f}{function that returns a single scalar value proportional to the log
probability density to sample from.}

\item{inits}{numeric vector with the initial values for the parameters to
estimate}

\item{theta.cov}{covariance matrix of the parameters to estimate.}

\item{max.iter}{maximum number of function evaluations}

\item{coda}{logical. Should the samples be returned as \link[coda:mcmc]{coda::mcmc}
object? (defaults to \code{FALSE})}

\item{...}{further arguments passed to \code{f}}
}
\value{
\itemize{
\item if \code{coda = FALSE} a list with:
\itemize{
\item \emph{samples}: A two dimensional array of samples with dimensions
\code{generation} x \code{parameter}
\item \emph{log.p}: A numeric vector with the log density evaluate at each
generation.
}
\item if \code{coda = TRUE} a list with:
\itemize{
\item \emph{samples}: A object of class \link[coda:mcmc]{coda::mcmc} containing all samples.
\item \emph{log.p}: A numeric vector with the log density evaluate at each
generation.
}
}
}
\description{
Simple Metropolis-Hastings MCMC
}
\examples{
p.log <- function(x) {
B <- 0.03
return(-x[1]^2/200 - 1/2*(x[2]+B*x[1]^2-100*B)^2)
}

simpleMH(p.log, inits=c(0, 0), theta.cov = diag(2), max.iter=3000)

}
