% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSNR.R
\name{estimateSNR}
\alias{estimateSNR}
\title{computes the signal-to-noise ratio}
\usage{
estimateSNR(x, numPerm = NA, nu = NA, quantiles = c(0.05, 0.95))
}
\arguments{
\item{x}{A (non-empty) numeric vector of data values.}

\item{numPerm}{The number of permutations (or shuffling) of the order of the sample values. By default set to \code{min(100,3 log(length(x)))}.}

\item{nu}{the Student t-distribution tail exponent of the sample data (if know). By default: NA. If set to NA, the tail exponent of the data is obtained from fit to a Student t-distribution. If NA, nu is estimated.}

\item{quantiles}{a vector of the lower and upper quantile needed to compute the confidence interval (use only if nu is known).}
}
\value{
a list element \itemize{
\item SNR The signal-to-noise ratio. To have something comparable with a t-statistics, multiply by \code{sqrt(length(x))}. To have a Sharpe ratio, multiply by the correct factor (\code{sqrt(252)}) for daily returns)
\item SNR.ci The 95% confidence interval if $\nu$ is known. If not, do not trust this.
\item nu The fitted Student t-distribution tail exponent.
\item R0bar The number of upper records minus the number of lower records of the cumulated sum of \code{x}.
\item N The length of the vector \code{x}. It may be smaller than the input length if x contains NAs.}
}
\description{
computes the signal-to-noise ratio
}
\examples{
  x <- rt(100,3)/sqrt(3)+0.05  #some Student-t distributed synthetic price log-returns
  estimateSNR(x)    
}
