% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_pattern.R
\name{reconstruct_pattern}
\alias{reconstruct_pattern}
\title{reconstruct_pattern}
\usage{
reconstruct_pattern(pattern, n_random = 1, e_threshold = 0.01,
  max_runs = 1000, no_change = Inf, fitting = FALSE, annealing = 0,
  comp_fast = 1000, weights = c(0.5, 0.5), return_input = TRUE,
  simplify = FALSE, verbose = TRUE, plot = FALSE)
}
\arguments{
\item{pattern}{ppp.}

\item{n_random}{Number of randomizations.}

\item{e_threshold}{Minimum energy to stop reconstruction.}

\item{max_runs}{Maximum number of iterations of e_threshold is not reached.}

\item{no_change}{Reconstrucction will stop if energy does not decrease for this number of iterations.}

\item{fitting}{It true, the pattern reconstruction starts with a fitting of a Thomas process.}

\item{annealing}{Probability to keep relocated point even if energy did not decrease.}

\item{comp_fast}{If pattern contains more points than threshold, summary functions are estimated in a computational fast way.}

\item{weights}{Weights used to calculate energy. The first number refers to Gest(r), the second number to pcf(r).}

\item{return_input}{The original input data is returned as last list entry}

\item{simplify}{If n_random = 1 and return_input = FALSE only pattern will be returned.}

\item{verbose}{Print progress report.}

\item{plot}{Plot pcf function during optimization.}
}
\value{
list
}
\description{
Pattern reconstruction
}
\details{
The functions randomizes the observed pattern by using pattern reconstruction
as described in Tscheschel & Stoyan (2006) and Wiegand & Moloney (2014). The
algorithm starts with a random reconstructed pattern, shifts a point to a new location and
keeps the change only, if the deviation between the observed and the reconstructed
pattern decreases. The pair correlation function and the nearest neighbour
distance function are used to describe the patterns.

For large patterns (\code{n > comp_fast}) the pair correlation function can be estimated
from Ripley's K-function without edge correction. This decreases the computational
time. For more information see \code{\link{estimate_pcf_fast}}.

The reconstruction can be stopped automatically if for n steps the energy does not
decrease. The number of steps can be controlled by \code{no_change} and is set to
\code{no_change = Inf} as default to never stop automatically.

The weights must be 0 < sum(weights) <= 1. To weight both summary functions identical,
use \code{weights = c(0.5, 0.5)}.
}
\examples{
\dontrun{
pattern_recon <- reconstruct_pattern(species_b, n_random = 19, max_runs = 1000)
}

}
\references{
Tscheschel, A., & Stoyan, D. (2006). Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis, 51(2), 859-871.

Wiegand, T., & Moloney, K. A. (2014). Handbook of spatial point-pattern analysis
in ecology. Boca Raton: Chapman and Hall/CRC Press.
}
\seealso{
\code{\link{calculate_energy}} \cr
\code{\link{plot_randomized_pattern}}
}
