% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_balanced.R
\name{sample_balanced}
\alias{sample_balanced}
\title{Balanced sampling}
\usage{
sample_balanced(
  mraster,
  nSamp,
  algorithm = "lpm2_kdtree",
  p = NULL,
  access = NULL,
  buff_inner = NULL,
  buff_outer = NULL,
  plot = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{algorithm}{Character. One of \code{lpm2_kdtree, lcube, lcubestratified}.}

\item{p}{Numeric. Vector with length equal to the number of cells in \code{mraster} representing
the inclusion probability for each candidate sample. Default = \code{nSamp / N}, where \code{N}
is the number of cells.}

\item{access}{sf 'LINESTRING' or 'MULTILINESTRING'. Access network.}

\item{buff_inner}{Numeric. Inner buffer boundary specifying distance
from access where plots cannot be sampled.}

\item{buff_outer}{Numeric. Outer buffer boundary specifying distance
from access where plots can be sampled.}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}
}
\value{
An sf object with \code{nSamp} samples.
}
\description{
Balanced raster sampling using \code{\link[BalancedSampling]{lcube}} and
\code{\link[SamplingBigData]{lpm2_kdtree}} methods
}
\examples{
#--- Load raster and existing plots---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

a <- system.file("extdata", "access.shp", package = "sgsR")
ac <- sf::st_read(a)

sample_balanced(
  mraster = mr,
  nSamp = 200
)

}
\references{
Anton Grafstrom and Jonathan Lisic (2019). BalancedSampling: Balanced and Spatially
Balanced Sampling. R package version 1.5.5. https://CRAN.R-project.org/package=BalancedSampling

Jonathan Lisic and Anton Grafstrom (2018). SamplingBigData: Sampling Methods for
Big Data. R package version 1.0.0. https://CRAN.R-project.org/package=SamplingBigData

Grafström, A. Lisic, J (2018). BalancedSampling: Balanced and Spatially Balanced Sampling.
 R package version 1.5.4. http://www.antongrafstrom.se/balancedsampling
}
\seealso{
Other sample functions: 
\code{\link{sample_ahels}()},
\code{\link{sample_clhs}()},
\code{\link{sample_existing}()},
\code{\link{sample_nc}()},
\code{\link{sample_srs}()},
\code{\link{sample_strat}()},
\code{\link{sample_systematic}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{sample functions}
