% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfnetworks.R
\name{st_as_nodes}
\alias{st_as_nodes}
\alias{st_as_nodes.sf}
\alias{st_as_nodes.sfc}
\title{Convert to a node point object}
\usage{
st_as_nodes(x, nb)

\method{st_as_nodes}{sf}(x, nb)

\method{st_as_nodes}{sfc}(x, nb)
}
\arguments{
\item{x}{object of class \code{sf} or \code{sfc}.}

\item{nb}{a neighbor list. If \code{x} is class \code{sf}, the unquote named of the column. If \code{x} is class \code{sfc}, an object of class \code{nb} as created from \code{st_contiguity()}.}
}
\value{
An object of class \code{sf} with \code{POINT} geometry.
}
\description{
Given geometry and a neighbor list, creates an \code{sf} object to be used as nodes in an \code{\link[sfnetworks:sfnetwork]{sfnetworks::sfnetwork()}}. If the provided geometry is a polygon, \code{\link[sf:geos_unary]{sf::st_point_on_surface()}} will be used to create the node point.
}
\details{
\code{st_as_node()} adds a row \code{i} based on the attribute \code{"region.id"} in the \code{nb} object. If the \code{nb} object is created with \code{sfdep}, then the values will always be row indexes.
}
\examples{
library(magrittr)
guerry \%>\%
  dplyr::transmute(nb = st_contiguity(geometry)) \%>\%
  st_as_nodes(nb)
}
