% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeSeries.R
\name{sentopics_labels}
\alias{sentopics_labels}
\alias{sentopics_labels<-}
\title{Setting topic or sentiment labels}
\usage{
sentopics_labels(x, flat = TRUE)

sentopics_labels(x) <- value
}
\arguments{
\item{x}{a \code{sentopicmodel} created from the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}}, \code{\link[=rJST]{rJST()}} or
\code{\link[=sentopicmodel]{sentopicmodel()}} function}

\item{flat}{if FALSE, return a list of dimension labels instead of a
character vector.}

\item{value}{a list of future labels for the topic model. The list should be
named and contain a character vector for each dimension to label. See the
examples for a correct usage.}
}
\value{
a character vector of topic/sentiment labels.
}
\description{
Extract or replace the labels of a \code{sentopicmodel}. The replaced
labels will appear in most functions dealing with the output of the
\code{sentomicmodel}.
}
\examples{
# by default, sentopics_labels() generate standard topic names
lda <- LDA(ECB_press_conferences_tokens)
sentopics_labels(lda)

# to change labels, a named list must be provided
sentopics_labels(lda) <- list(
 topic = paste0("superTopic", 1:lda$K)
)
sentopics_labels(lda)

# using NULL remove labels
sentopics_labels(lda) <- NULL
sentopics_labels(lda)

# also works for JST/rJST models
jst <- JST(ECB_press_conferences_tokens)
sentopics_labels(jst) <- list(
  topic = paste0("superTopic", 1:jst$K),
  sentiment = c("negative", "neutral", "positive")
)
sentopics_labels(jst)

# setting flat = FALSE return a list or labels for each dimension
sentopics_labels(jst, flat = FALSE)
}
\seealso{
mergeTopics

Other sentopics helpers: 
\code{\link{sentopics_date}()},
\code{\link{sentopics_sentiment}()}
}
\author{
Olivier Delmarcelle
}
\concept{sentopics helpers}
