% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selacSim.R
\name{SelacHMMSimulator}
\alias{SelacHMMSimulator}
\title{Simulate DNA under the SELAC model}
\usage{
SelacHMMSimulator(phy, pars, nsites, codon.freq.by.aa = NULL,
  codon.freq.by.gene = NULL, numcode = 1, aa.properties = NULL,
  nuc.model, include.gamma = FALSE, gamma.type = "quadrature",
  ncats = 4, k.levels = 0, diploid = TRUE, site.cats.vector = NULL)
}
\arguments{
\item{phy}{The phylogenetic tree with branch lengths.}

\item{pars}{A vector of parameters used for the simulation.
They are ordered as follows: C.q.phi, alpha, beta, Ne, base.freqs for A C G,
and the rates for the nucleotide model the very last parameter is always the switching rate of the optimal AA.}

\item{nsites}{Length of the alignment to be simulated}

\item{codon.freq.by.aa}{A matrix of codon frequencies for each possible optimal amino acid. Rows are aa (including stop codon), cols are codons.}

\item{codon.freq.by.gene}{A matrix of codon frequencies for each gene.}

\item{numcode}{The ncbi genetic code number for translation. By default the standard (numcode=1) genetic code is used.}

\item{aa.properties}{User-supplied amino acid distance properties. By default we assume Grantham (1974) properties.}

\item{nuc.model}{Indicates what type nucleotide model to use. There are three options: "JC", "GTR", or "UNREST".}

\item{include.gamma}{A logical indicating whether or not to include a discrete gamma model.}

\item{gamma.type}{Indicates what type of gamma distribution to use.
Options are "quadrature" after the Laguerre quadrature approach of Felsenstein 2001 or median approach of Yang 1994.}

\item{ncats}{The number of discrete categories.}

\item{k.levels}{Provides how many levels in the polynomial. By default we assume a single level (i.e., linear).}

\item{diploid}{A logical indicating whether or not the organism is diploid or not.}

\item{site.cats.vector}{A vector designating the rate category for phi when include.gamma=TRUE.}
}
\description{
Simulates nucleotide data based on parameters under the SELAC model
}
\details{
Simulates a nucleotide matrix using parameters under the SELAC model.
Note that the output can be written to a fasta file using the write.dna() function in the \code{ape} package.
}
